/*
 * Decompiled with CFR 0.152.
 */
package art;

import art.DTrackSDK;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;

class DTrackNetTCP {
    private String tcpPacketContent = null;
    private Socket socket = null;
    private OutputStreamWriter writer = null;
    private InputStreamReader reader = null;
    private static Logger log = Logger.getLogger(DTrackSDK.class.getName());

    protected DTrackNetTCP(InetAddress inetAddress, int n, int n2) {
        Socket socket = new Socket();
        InetSocketAddress inetSocketAddress = new InetSocketAddress(inetAddress, n);
        OutputStreamWriter outputStreamWriter = null;
        InputStreamReader inputStreamReader = null;
        try {
            socket.setTcpNoDelay(true);
            socket.connect(inetSocketAddress, n2);
            outputStreamWriter = new OutputStreamWriter(socket.getOutputStream(), "UTF-8");
            inputStreamReader = new InputStreamReader(socket.getInputStream(), "UTF-8");
        }
        catch (IOException iOException) {
            log.log(Level.SEVERE, "TCP socket connection failed", iOException);
            try {
                socket.close();
            }
            catch (IOException iOException2) {
                log.log(Level.WARNING, "Exception", iOException2);
            }
            return;
        }
        this.socket = socket;
        this.writer = outputStreamWriter;
        this.reader = inputStreamReader;
    }

    protected int close() {
        if (this.socket == null) {
            return 0;
        }
        try {
            if (!this.socket.isInputShutdown() && !this.socket.isClosed()) {
                this.socket.shutdownInput();
            }
            if (!this.socket.isOutputShutdown() && !this.socket.isClosed()) {
                this.socket.shutdownOutput();
            }
            if (!this.socket.isClosed()) {
                this.socket.close();
            }
            return 0;
        }
        catch (IOException iOException) {
            log.log(Level.WARNING, "Can't close TCP socket", iOException);
            return -1;
        }
    }

    protected boolean isValid() {
        if (this.socket == null) {
            return false;
        }
        return !this.socket.isClosed();
    }

    protected String getPacketContent() {
        return this.tcpPacketContent;
    }

    protected int receive(int n, int n2) {
        this.tcpPacketContent = null;
        if (this.socket.isInputShutdown()) {
            return -1;
        }
        char[] cArray = new char[n];
        try {
            int n3;
            this.socket.setSoTimeout(n2);
            while ((n3 = this.reader.read(cArray, 0, n)) <= 0) {
                if (n3 >= 0) continue;
                return -2;
            }
        }
        catch (SocketTimeoutException socketTimeoutException) {
            log.warning("TCP receive timeout");
            return -1;
        }
        catch (IOException iOException) {
            log.log(Level.SEVERE, "Can't receive TCP data", iOException);
            return -2;
        }
        this.tcpPacketContent = new String(cArray);
        return this.tcpPacketContent.length();
    }

    protected int send(String string, int n) {
        if (this.socket.isOutputShutdown()) {
            return -1;
        }
        try {
            this.socket.setSoTimeout(n);
            this.writer.write(string, 0, string.length());
            this.writer.flush();
        }
        catch (SocketTimeoutException socketTimeoutException) {
            log.log(Level.SEVERE, "TCP send timeout", socketTimeoutException);
            return -1;
        }
        catch (IOException iOException) {
            log.log(Level.SEVERE, "Can't send TCP data", iOException);
            return -2;
        }
        return 0;
    }
}

