/*
 * Decompiled with CFR 0.152.
 */
package art;

import art.DTrackFinger;

public class DTrackHand {
    private int id;
    private double quality;
    private int lr;
    private double[] loc;
    private double[][] rot;
    private DTrackFinger[] finger;

    protected DTrackHand(int n) {
        this.id = n;
        this.lr = 0;
        this.quality = -1.0;
        this.loc = new double[3];
        this.rot = new double[3][3];
        this.finger = new DTrackFinger[0];
    }

    protected DTrackHand(int n, int n2, double d, double[] dArray, double[][] dArray2, DTrackFinger[] dTrackFingerArray) {
        this.id = n;
        this.lr = n2;
        this.quality = d;
        this.loc = dArray;
        this.rot = dArray2;
        this.finger = dTrackFingerArray;
    }

    public int getId() {
        return this.id;
    }

    public boolean isTracked() {
        return !(this.quality < 0.0);
    }

    public double getQuality() {
        return this.quality;
    }

    public int getLr() {
        return this.lr;
    }

    public int getNumFinger() {
        return this.finger.length;
    }

    public double[] getLoc() {
        return this.loc;
    }

    public double[][] getRot() {
        return this.rot;
    }

    public DTrackFinger[] getFinger() {
        return this.finger;
    }

    public DTrackFinger getFinger(int n) {
        return this.finger[n];
    }

    protected void setNotTracked() {
        this.quality = -1.0;
    }
}

