#region Using Statements
using System;
using System.Collections.Generic;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Audio;
using Microsoft.Xna.Framework.Content;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Input;
using Microsoft.Xna.Framework.Storage;
#endregion

namespace tdx_demo
{
    /// <summary>
    /// This is the main type for your game
    /// </summary>
    public class Game1 : Microsoft.Xna.Framework.Game
    {
        TDxInput.Device device = new TDxInput.Device();
        private TDxInput.Keyboard keyboard;

        int deviceType;
        private Model myDice;

        private Matrix MyModelTranslation = Matrix.Identity;
        private Matrix MyModelRotation = Matrix.Identity;

        GraphicsDeviceManager graphics;
        ContentManager content;

        SpriteBatch ForegroundBatch;

        public Game1()
        {
            graphics = new GraphicsDeviceManager(this);
            content = new ContentManager(Services);
            IsMouseVisible = true;
            IsFixedTimeStep = false;
        }


        /// <summary>
        /// Allows the game to perform any initialization it needs to before starting to run.
        /// This is where it can query for any required services and load any non-graphic
        /// related content.  Calling base.Initialize will enumerate through any components
        /// and initialize them as well.
        /// </summary>
        protected override void Initialize()
        {
            device.Connect();
            keyboard = device.Keyboard;
            keyboard.KeyDown += new TDxInput._IKeyboardEvents_KeyDownEventHandler(keyboard_KeyDown);
            deviceType = device.Type;
            
            base.Initialize();
        }

        void keyboard_KeyDown(int keyCode)
        {
            if (keyCode == 31)
            {
                // Fit View
                MyModelTranslation.Translation = Vector3.Zero;
            }
        }


        /// <summary>
        /// Load your graphics content.  If loadAllContent is true, you should
        /// load content from both ResourceManagementMode pools.  Otherwise, just
        /// load ResourceManagementMode.Manual content.
        /// </summary>
        /// <param name="loadAllContent">Which type of content to load.</param>
        protected override void LoadGraphicsContent(bool loadAllContent)
        {
            if (loadAllContent)
            {
                myDice = content.Load<Model>("media\\dice");
                ForegroundBatch = new SpriteBatch(graphics.GraphicsDevice);
            }

            // TODO: Load any ResourceManagementMode.Manual content
        }


        /// <summary>
        /// Unload your graphics content.  If unloadAllContent is true, you should
        /// unload content from both ResourceManagementMode pools.  Otherwise, just
        /// unload ResourceManagementMode.Manual content.  Manual content will get
        /// Disposed by the GraphicsDevice during a Reset.
        /// </summary>
        /// <param name="unloadAllContent">Which type of content to unload.</param>
        protected override void UnloadGraphicsContent(bool unloadAllContent)
        {
            if (unloadAllContent == true)
            {
                device.Disconnect();
                content.Unload();                
            }
        }

        /// <summary>
        /// Allows the game to run logic such as updating the world,
        /// checking for collisions, gathering input and playing audio.
        /// </summary>
        /// <param name="gameTime">Provides a snapshot of timing values.</param>
        protected override void Update(GameTime gameTime)
        {
            Update3DInput(gameTime);
            base.Update(gameTime);
        }

        
        private void Update3DInput(GameTime gameTime)
        {
            float scale = (float)device.Sensor.Period;
            if (scale > 0 && (gameTime.ElapsedGameTime.Milliseconds > 0))
            {
                scale /= gameTime.ElapsedGameTime.Milliseconds;

                // Translation
                Vector3 translation = new Vector3((float)device.Sensor.Translation.X,
                                                  (float)device.Sensor.Translation.Y,
                                                  (float)device.Sensor.Translation.Z);
                translation /= 32.0f / scale;
                MyModelTranslation.Translation += translation;

                // Rotation
                Vector3 rotation = new Vector3((float)device.Sensor.Rotation.X,
                                               (float)device.Sensor.Rotation.Y,
                                               (float)device.Sensor.Rotation.Z);

                MyModelRotation *= Matrix.CreateFromAxisAngle(rotation, (float)device.Sensor.Rotation.Angle / 1024.0f / scale);
            }
        }

        private void DrawModel(Model m)
        {
            Matrix[] transforms = new Matrix[m.Bones.Count];
            float aspectRatio = graphics.GraphicsDevice.Viewport.Width / graphics.GraphicsDevice.Viewport.Height;
            m.CopyAbsoluteBoneTransformsTo(transforms);
                        
            foreach (ModelMesh mesh in m.Meshes)
            {
                foreach (BasicEffect effect in mesh.Effects)
                {
                    effect.EnableDefaultLighting();
                    effect.World = MyModelRotation *MyModelTranslation *transforms[mesh.ParentBone.Index];
                    effect.View = Matrix.CreateLookAt(new Vector3(0, 1, 100), Vector3.Zero, Vector3.Up);
                    effect.Projection = Matrix.CreatePerspectiveFieldOfView(MathHelper.ToRadians(30.0f), aspectRatio, 1.0f, 10000.0f);
                }
                mesh.Draw();
            }
        }

        /// <summary>
        /// This is called when the game should draw itself.
        /// </summary>
        /// <param name="gameTime">Provides a snapshot of timing values.</param>
        protected override void Draw(GameTime gameTime)
        {
          graphics.GraphicsDevice.Clear(Color.CornflowerBlue);
          DrawModel(myDice);
          base.Draw(gameTime);
        }
    }
}