Public Class Form1

    ' This delegate enables asynchronous calls for setting
    ' the text property on a TextBox control.
    Delegate Sub SetMotionTextCallback()
    Delegate Sub SetKeyTextCallback(keyCode As Integer)

    Private WithEvents Sensor As TDxInput.Sensor
    Private WithEvents Keyboard As TDxInput.Keyboard
    Private WithEvents Device As TDxInput.Device

    Public Sub New()

        ' This call is required by the Windows Form Designer.
        InitializeComponent()

        ' Add any initialization after the InitializeComponent() call.
        Device = New TDxInput.Device
        Sensor = Device.Sensor
        Keyboard = Device.Keyboard

        SetMotionTexts()
        SetKeyText(1)

        Device.Connect()

    End Sub

    Private Sub Sensor_SensorInput() Handles Sensor.SensorInput

        Me.SetMotionTexts()

    End Sub


    ' This method demonstrates a pattern for making thread-safe
    ' calls on a Windows Forms control. 
    '
    ' If the calling thread is different from the thread that
    ' created the TextBox control, this method creates a
    ' SetTextCallback and calls itself asynchronously using the
    ' Invoke method.
    '
    ' If the calling thread is the same as the thread that created
    ' the TextBox control, the Text property is set directly. 

    Private Sub SetMotionTexts()
        ' InvokeRequired required compares the thread ID of the
        ' calling thread to the thread ID of the creating thread.
        ' If these threads are different, it returns true.
        If Me.TextBox1.InvokeRequired Then
            Dim d As New SetMotionTextCallback(AddressOf SetMotionTexts)
            Me.Invoke(d)
        Else
            Dim Style1 As String = "f"
            Dim translation As TDxInput.Vector3D
            translation = Sensor.Translation

            Dim rotation As TDxInput.AngleAxis
            rotation = Sensor.Rotation

            Me.TextBox1.Text = Format(translation.X, Style1)
            Me.TextBox2.Text = Format(translation.Y, Style1)
            Me.TextBox3.Text = Format(translation.Z, Style1)

            Me.TextBox6.Text = Format(rotation.X, Style1)
            Me.TextBox5.Text = Format(rotation.Y, Style1)
            Me.TextBox4.Text = Format(rotation.Z, Style1)
            Me.TextBox7.Text = Format(rotation.Angle, Style1)

        End If
    End Sub

    Private Sub Keyboard_KeyDown(ByVal keyCode As Integer) Handles Keyboard.KeyDown

        Me.SetKeyText(keyCode)

    End Sub

    Private Sub Keyboard_KeyUp(ByVal keyCode As Integer) Handles Keyboard.KeyUp

        Me.SetKeyText(keyCode)

    End Sub


    Private Sub SetKeyText(ByVal key As Integer)
        ' InvokeRequired required compares the thread ID of the
        ' calling thread to the thread ID of the creating thread.
        ' If these threads are different, it returns true.
        If Me.TextBox1.InvokeRequired Then
            Dim d As New SetKeyTextCallback(AddressOf SetKeyText)
            Me.Invoke(d, key)
        Else
            If (Keyboard.IsKeyDown(key)) Then
                Me.TextBox8.Text = key
            Else
                Me.TextBox8.Clear()
            End If
        End If
    End Sub


    Protected Overrides Sub Finalize()
        Device.Disconnect()
        MyBase.Finalize()
    End Sub
End Class
