using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Runtime.InteropServices;
using TDx.TDxInput;

namespace Monitor
{
   public partial class csMonitor : Form
   {
      private delegate void SetDeviceTextCallback();
      private delegate void SetMotionTextCallback();
      private delegate void SetKeyTextCallback(int keyCode);

      private TDx.TDxInput.Sensor sensor; 
      private TDx.TDxInput.Keyboard keyboard;
      private TDx.TDxInput.Device device;
      private System.DateTime lastUpdate;
      private bool isRunning;

      public csMonitor()
      {
         InitializeComponent();
         isRunning = false;
         try
         {
            this.device = new TDx.TDxInput.Device();
            sensor = this.device.Sensor;

            this.keyboard = this.device.Keyboard;


            this.lastUpdate = System.DateTime.Now;

            SetDeviceText();
            SetMotionTexts();
            SetKeyText(1);

            // Add the event handlers
            this.device.DeviceChange += new TDx.TDxInput._ISimpleDeviceEvents_DeviceChangeEventHandler(this.device_DeviceChange);
            this.sensor.SensorInput += new TDx.TDxInput._ISensorEvents_SensorInputEventHandler(this.sensor_SensorInput);
            this.keyboard.KeyDown += new TDx.TDxInput._IKeyboardEvents_KeyDownEventHandler(this.keyboard_KeyDown);
            this.keyboard.KeyUp += new TDx.TDxInput._IKeyboardEvents_KeyUpEventHandler(this.keyboard_KeyUp);

            // Associate a configuration with this device'
            this.device.LoadPreferences("csMonitor");

            //Connect everything up
            this.device.Connect();

            device_DeviceChange(0);
         }
         catch (COMException e)
         {
            Console.WriteLine("{0} Caught exception #1.", e);
         }
      }

      void SetDeviceText()
      {
         // InvokeRequired required compares the thread ID of the
         // calling thread to the thread ID of the creating thread.
         // If these threads are different, it returns true.
         if (this.deviceType.InvokeRequired)
         {
            SetDeviceTextCallback d  = new SetDeviceTextCallback(this.SetDeviceText);
            this.Invoke(d);
         }
         else
         {
            this.deviceType.Text = this.device.Type.ToString();      
         }
      }

      void SetMotionTexts()
      {
         // InvokeRequired required compares the thread ID of the
         // calling thread to the thread ID of the creating thread.
         //' If these threads are different, it returns true.
         if (this.rx.InvokeRequired)
         {
            SetMotionTextCallback d  = new SetMotionTextCallback(this.SetMotionTexts);
            this.Invoke(d);
         }
         else
         {
            double timeFactor;

            if (false)
            {
               // Adjust values to account for gui update rate
               // as this is a velocity device
               System.DateTime now = System.DateTime.Now;
               System.TimeSpan deltaUpdate = now - lastUpdate;
               lastUpdate = now;

               timeFactor = (double)deltaUpdate.Milliseconds / sensor.Period;
               if (!this.isRunning)
                  timeFactor = 1;
            }
            else
            {
               // In a value monitor the update rate is irrelevant
               timeFactor = 1;
            }


            String style1  = "f";
            TDx.TDxInput.Vector3D translation;
            translation = sensor.Translation;
            translation.Length = translation.Length * timeFactor;

            TDx.TDxInput.AngleAxis rotation;
            rotation = sensor.Rotation;
            rotation.Angle = rotation.Angle * timeFactor;

            if (translation.Length > 0 ||  rotation.Angle > 0)
               this.isRunning = true;
            else
               this.isRunning = false;

            this.tx.Text = translation.X.ToString(style1);
            this.ty.Text = translation.Y.ToString(style1);
            this.tz.Text = translation.Z.ToString(style1);

            this.rx.Text = rotation.X.ToString(style1);
            this.ry.Text = rotation.Y.ToString(style1);
            this.rz.Text = rotation.Z.ToString(style1);
            this.ra.Text = rotation.Angle.ToString(style1);

         }
         System.GC.Collect();
      }

      void SetKeyText(int key)
      {
         // InvokeRequired required compares the thread ID of the
         // calling thread to the thread ID of the creating thread.
         // If these threads are different, it returns true.
         if (this.keyNumber.InvokeRequired)
         {
            SetKeyTextCallback d  = new SetKeyTextCallback(this.SetKeyText);
            System.Object args = (key);
            this.Invoke(d, args);
         }
         else
         {
            if (keyboard.IsKeyDown(key))
               this.keyNumber.Text = key.ToString();
            else
               this.keyNumber.Clear();
         }
      }

      void device_DeviceChange(int reserved)
      {
         SetDeviceText();
         int key;
         string strKeyLabel;
         for (key = 1; key <= this.keyboard.Keys; key++)
         {
            strKeyLabel = this.keyboard.GetKeyLabel(key);
            Console.WriteLine("KeyLabel is {0}.", strKeyLabel);
         }
      }

      void sensor_SensorInput()
      {
         SetMotionTexts();
      }

      void keyboard_KeyDown(int key)
      {
         SetKeyText(key);
      }

      void keyboard_KeyUp(int key)
      {
         SetKeyText(key);
      }
   }
}