#pragma once


namespace NETMonitor
{
   using namespace System;
   using namespace System::ComponentModel;
   using namespace System::Collections;
   using namespace System::Windows::Forms;
   using namespace System::Data;
   using namespace System::Drawing;
   using namespace System::Diagnostics;

   /// <summary> 
   /// Summary for Form1
   ///
   /// WARNING: If you change the name of this class, you will need to change the 
   ///          'Resource File Name' property for the managed resource compiler tool 
   ///          associated with all .resx files this class depends on.  Otherwise,
   ///          the designers will not be able to interact properly with localized
   ///          resources associated with this form.
   /// </summary>
public __gc class Form1 : public System::Windows::Forms::Form
{	
private:
   __delegate void SetDeviceTextCallback(void);
   __delegate void SetMotionTextCallback(void);
   __delegate void SetKeyTextCallback(int keyCode);

public:
   Form1(void)
   {
      InitializeComponent();

      this->device = new TDx::TDxInput::DeviceClass();
      this->sensor = this->device->Sensor;
      this->keyboard = this->device->Keyboard;

      this->isRunning = false;
      this->lastUpdate = System::DateTime::Now;
      SetDeviceText();
      SetMotionTexts();
      SetKeyText(1);

      // Add the event handlers
      this->device->DeviceChange += new TDx::TDxInput::_ISimpleDeviceEvents_DeviceChangeEventHandler(this, &NETMonitor::Form1::device_DeviceChange);
      sensor->SensorInput += new TDx::TDxInput::_ISensorEvents_SensorInputEventHandler(this, &NETMonitor::Form1::sensor_SensorInput);
      this->keyboard->KeyDown += new TDx::TDxInput::_IKeyboardEvents_KeyDownEventHandler(this, &NETMonitor::Form1::keyboard_KeyDown);
      this->keyboard->KeyUp += new TDx::TDxInput::_IKeyboardEvents_KeyUpEventHandler(this, &NETMonitor::Form1::keyboard_KeyUp);

      // Associate a configuration with this device'
      this->device->LoadPreferences(".netMonitor");

      //Connect everything up
      this->device->Connect();
      this->isConnected = this->device->IsConnected;

   }

   virtual ~Form1(void)
   {
      this->device->Disconnect();
   }

protected:
   void Dispose(Boolean disposing)
   {
      if (disposing && components)
      {
         components->Dispose();
      }
      if (disposing && device)
      {
         device->Disconnect();
      }
      __super::Dispose(disposing);
   }
private: System::Windows::Forms::Label *  label1;
private: System::Windows::Forms::Label *  label2;
private: System::Windows::Forms::Label *  label3;
private: System::Windows::Forms::Label *  label4;
private: System::Windows::Forms::Label *  label5;
private: System::Windows::Forms::Label *  label6;
private: System::Windows::Forms::Label *  label7;
private: System::Windows::Forms::Label *  label8;
private: System::Windows::Forms::Label *  label9;
private: System::Windows::Forms::Label *  label10;
private: System::Windows::Forms::Label *  label11;

private: System::Windows::Forms::TextBox *  deviceType;
private: System::Windows::Forms::TextBox *  tx;
private: System::Windows::Forms::TextBox *  ty;
private: System::Windows::Forms::TextBox *  tz;
private: System::Windows::Forms::TextBox *  rx;
private: System::Windows::Forms::TextBox *  ry;
private: System::Windows::Forms::TextBox *  rz;
private: System::Windows::Forms::TextBox *  ra;

private:
   TDx::TDxInput::Sensor* sensor;
   TDx::TDxInput::Keyboard* keyboard;
   TDx::TDxInput::Device* device;
   System::DateTime lastUpdate;
   bool isRunning;
   bool isConnected;
private: System::Windows::Forms::TextBox *  keyNumber;

private:
   /// <summary>
   /// Required designer variable.
   /// </summary>
   System::ComponentModel::Container * components;

   /// <summary>
   /// Required method for Designer support - do not modify
   /// the contents of this method with the code editor.
   /// </summary>
   void InitializeComponent(void)
   {
      this->isConnected = false;
      this->deviceType = new System::Windows::Forms::TextBox();
      this->label1 = new System::Windows::Forms::Label();
      this->label2 = new System::Windows::Forms::Label();
      this->label3 = new System::Windows::Forms::Label();
      this->label4 = new System::Windows::Forms::Label();
      this->label5 = new System::Windows::Forms::Label();
      this->label6 = new System::Windows::Forms::Label();
      this->tx = new System::Windows::Forms::TextBox();
      this->ty = new System::Windows::Forms::TextBox();
      this->tz = new System::Windows::Forms::TextBox();
      this->rz = new System::Windows::Forms::TextBox();
      this->ry = new System::Windows::Forms::TextBox();
      this->rx = new System::Windows::Forms::TextBox();
      this->label7 = new System::Windows::Forms::Label();
      this->label8 = new System::Windows::Forms::Label();
      this->label9 = new System::Windows::Forms::Label();
      this->ra = new System::Windows::Forms::TextBox();
      this->label10 = new System::Windows::Forms::Label();
      this->keyNumber = new System::Windows::Forms::TextBox();
      this->label11 = new System::Windows::Forms::Label();
      this->SuspendLayout();
      // 
      // deviceType
      // 
      this->deviceType->BackColor = System::Drawing::SystemColors::Control;
      this->deviceType->Location = System::Drawing::Point(184, 32);
      this->deviceType->Name = S"deviceType";
      this->deviceType->ReadOnly = true;
      this->deviceType->Size = System::Drawing::Size(72, 20);
      this->deviceType->TabIndex = 0;
      this->deviceType->Text = S"0";
      this->deviceType->TextAlign = System::Windows::Forms::HorizontalAlignment::Right;
      this->deviceType->WordWrap = false;
      // 
      // label1
      // 
      this->label1->Location = System::Drawing::Point(104, 32);
      this->label1->Name = S"label1";
      this->label1->Size = System::Drawing::Size(72, 16);
      this->label1->TabIndex = 1;
      this->label1->Text = S"Device Type:";
      // 
      // label2
      // 
      this->label2->Location = System::Drawing::Point(32, 80);
      this->label2->Name = S"label2";
      this->label2->Size = System::Drawing::Size(72, 16);
      this->label2->TabIndex = 2;
      this->label2->Text = S"Translation";
      // 
      // label3
      // 
      this->label3->Location = System::Drawing::Point(144, 80);
      this->label3->Name = S"label3";
      this->label3->Size = System::Drawing::Size(72, 16);
      this->label3->TabIndex = 3;
      this->label3->Text = S"Rotation";
      // 
      // label4
      // 
      this->label4->Location = System::Drawing::Point(32, 112);
      this->label4->Name = S"label4";
      this->label4->Size = System::Drawing::Size(16, 16);
      this->label4->TabIndex = 4;
      this->label4->Text = S"X:";
      // 
      // label5
      // 
      this->label5->Location = System::Drawing::Point(32, 144);
      this->label5->Name = S"label5";
      this->label5->Size = System::Drawing::Size(16, 16);
      this->label5->TabIndex = 5;
      this->label5->Text = S"Y:";
      // 
      // label6
      // 
      this->label6->Location = System::Drawing::Point(32, 176);
      this->label6->Name = S"label6";
      this->label6->Size = System::Drawing::Size(16, 16);
      this->label6->TabIndex = 6;
      this->label6->Text = S"Z:";
      // 
      // tx
      // 
      this->tx->BackColor = System::Drawing::SystemColors::Control;
      this->tx->Location = System::Drawing::Point(56, 104);
      this->tx->Name = S"tx";
      this->tx->ReadOnly = true;
      this->tx->Size = System::Drawing::Size(72, 20);
      this->tx->TabIndex = 7;
      this->tx->Text = S"0";
      this->tx->TextAlign = System::Windows::Forms::HorizontalAlignment::Right;
      this->tx->WordWrap = false;
      // 
      // ty
      // 
      this->ty->BackColor = System::Drawing::SystemColors::Control;
      this->ty->Location = System::Drawing::Point(56, 136);
      this->ty->Name = S"ty";
      this->ty->ReadOnly = true;
      this->ty->Size = System::Drawing::Size(72, 20);
      this->ty->TabIndex = 8;
      this->ty->Text = S"0";
      this->ty->TextAlign = System::Windows::Forms::HorizontalAlignment::Right;
      this->ty->WordWrap = false;
      // 
      // tz
      // 
      this->tz->BackColor = System::Drawing::SystemColors::Control;
      this->tz->Location = System::Drawing::Point(56, 168);
      this->tz->Name = S"tz";
      this->tz->ReadOnly = true;
      this->tz->Size = System::Drawing::Size(72, 20);
      this->tz->TabIndex = 9;
      this->tz->Text = S"0";
      this->tz->TextAlign = System::Windows::Forms::HorizontalAlignment::Right;
      this->tz->WordWrap = false;
      // 
      // rz
      // 
      this->rz->BackColor = System::Drawing::SystemColors::Control;
      this->rz->Location = System::Drawing::Point(184, 168);
      this->rz->Name = S"rz";
      this->rz->ReadOnly = true;
      this->rz->Size = System::Drawing::Size(72, 20);
      this->rz->TabIndex = 15;
      this->rz->Text = S"0";
      this->rz->TextAlign = System::Windows::Forms::HorizontalAlignment::Right;
      this->rz->WordWrap = false;
      // 
      // ry
      // 
      this->ry->BackColor = System::Drawing::SystemColors::Control;
      this->ry->Location = System::Drawing::Point(184, 136);
      this->ry->Name = S"ry";
      this->ry->ReadOnly = true;
      this->ry->Size = System::Drawing::Size(72, 20);
      this->ry->TabIndex = 14;
      this->ry->Text = S"0";
      this->ry->TextAlign = System::Windows::Forms::HorizontalAlignment::Right;
      this->ry->WordWrap = false;
      // 
      // rx
      // 
      this->rx->BackColor = System::Drawing::SystemColors::Control;
      this->rx->Location = System::Drawing::Point(184, 104);
      this->rx->Name = S"rx";
      this->rx->ReadOnly = true;
      this->rx->Size = System::Drawing::Size(72, 20);
      this->rx->TabIndex = 13;
      this->rx->Text = S"0";
      this->rx->TextAlign = System::Windows::Forms::HorizontalAlignment::Right;
      this->rx->WordWrap = false;
      // 
      // label7
      // 
      this->label7->Location = System::Drawing::Point(160, 176);
      this->label7->Name = S"label7";
      this->label7->Size = System::Drawing::Size(16, 16);
      this->label7->TabIndex = 12;
      this->label7->Text = S"Z:";
      // 
      // label8
      // 
      this->label8->Location = System::Drawing::Point(160, 144);
      this->label8->Name = S"label8";
      this->label8->Size = System::Drawing::Size(16, 16);
      this->label8->TabIndex = 11;
      this->label8->Text = S"Y:";
      // 
      // label9
      // 
      this->label9->Location = System::Drawing::Point(160, 112);
      this->label9->Name = S"label9";
      this->label9->Size = System::Drawing::Size(16, 16);
      this->label9->TabIndex = 10;
      this->label9->Text = S"X:";
      // 
      // ra
      // 
      this->ra->BackColor = System::Drawing::SystemColors::Control;
      this->ra->Location = System::Drawing::Point(184, 200);
      this->ra->Name = S"ra";
      this->ra->ReadOnly = true;
      this->ra->Size = System::Drawing::Size(72, 20);
      this->ra->TabIndex = 17;
      this->ra->Text = S"0";
      this->ra->TextAlign = System::Windows::Forms::HorizontalAlignment::Right;
      this->ra->WordWrap = false;
      // 
      // label10
      // 
      this->label10->Location = System::Drawing::Point(136, 208);
      this->label10->Name = S"label10";
      this->label10->Size = System::Drawing::Size(40, 16);
      this->label10->TabIndex = 16;
      this->label10->Text = S"Angle:";
      // 
      // keyNumber
      // 
      this->keyNumber->BackColor = System::Drawing::SystemColors::Control;
      this->keyNumber->Location = System::Drawing::Point(184, 232);
      this->keyNumber->Name = S"keyNumber";
      this->keyNumber->ReadOnly = true;
      this->keyNumber->Size = System::Drawing::Size(72, 20);
      this->keyNumber->TabIndex = 19;
      this->keyNumber->Text = S"0";
      this->keyNumber->TextAlign = System::Windows::Forms::HorizontalAlignment::Right;
      this->keyNumber->WordWrap = false;
      // 
      // label11
      // 
      this->label11->Location = System::Drawing::Point(120, 240);
      this->label11->Name = S"label11";
      this->label11->Size = System::Drawing::Size(56, 16);
      this->label11->TabIndex = 18;
      this->label11->Text = S"Keydown:";
      // 
      // Form1
      // 
      this->AutoScaleBaseSize = System::Drawing::Size(5, 13);
      this->ClientSize = System::Drawing::Size(292, 334);
      this->Controls->Add(this->keyNumber);
      this->Controls->Add(this->label11);
      this->Controls->Add(this->ra);
      this->Controls->Add(this->label10);
      this->Controls->Add(this->rz);
      this->Controls->Add(this->ry);
      this->Controls->Add(this->rx);
      this->Controls->Add(this->label7);
      this->Controls->Add(this->label8);
      this->Controls->Add(this->label9);
      this->Controls->Add(this->tz);
      this->Controls->Add(this->ty);
      this->Controls->Add(this->tx);
      this->Controls->Add(this->label6);
      this->Controls->Add(this->label5);
      this->Controls->Add(this->label4);
      this->Controls->Add(this->label3);
      this->Controls->Add(this->label2);
      this->Controls->Add(this->label1);
      this->Controls->Add(this->deviceType);
      this->Name = S"Form1";
      this->Text = S".netMonitor";
      this->ResumeLayout(false);

   }	



   
  void SetDeviceText()
   {
      // InvokeRequired required compares the thread ID of the
      // calling thread to the thread ID of the creating thread.
      // If these threads are different, it returns true.
      if (this->deviceType->InvokeRequired)
      {
         SetDeviceTextCallback *d  = new SetDeviceTextCallback(this, &NETMonitor::Form1::SetDeviceText);
         this->Invoke(d);
      }
      else
      {
         this->deviceType->Text = this->device->Type.ToString();      
      }
   }

   void SetMotionTexts(void)
   {
      // InvokeRequired required compares the thread ID of the
      // calling thread to the thread ID of the creating thread.
      //' If these threads are different, it returns true.
      if (this->rx->InvokeRequired)
      {
         SetMotionTextCallback* d  = new SetMotionTextCallback(this, &NETMonitor::Form1::SetMotionTexts);
         this->Invoke(d);
      }
      else
      {
#if 0
         // Adjust values to account for update rate
         System::DateTime now = System::DateTime::Now;
         System::TimeSpan deltaUpdate = now - lastUpdate;
         lastUpdate = now;

         double timeFactor = (double)deltaUpdate.Milliseconds / this->sensor->Period;
         if (!this->isRunning)
            timeFactor = 1.;
#else
         // In a value monitor the update rate is irrelevant
         double timeFactor = 1.;
#endif
         String* style1  = "f";
         TDx::TDxInput::Vector3D* translation;
         translation = sensor->Translation;
         translation->Length = translation->Length * timeFactor;

         TDx::TDxInput::AngleAxis* rotation;
         rotation = sensor->Rotation;
         rotation->Angle = rotation->Angle * timeFactor;

         if (translation->Length > 0. ||  rotation->Angle > 0.)
            this->isRunning = true;
         else
            this->isRunning = false;

         this->tx->Text = translation->X.ToString(style1);
         this->ty->Text = translation->Y.ToString(style1);
         this->tz->Text = translation->Z.ToString(style1);

         this->rx->Text = rotation->X.ToString(style1);
         this->ry->Text = rotation->Y.ToString(style1);
         this->rz->Text = rotation->Z.ToString(style1);
         this->ra->Text = rotation->Angle.ToString(style1);

      }
   }

   void SetKeyText(int key)
   {
      // InvokeRequired required compares the thread ID of the
      // calling thread to the thread ID of the creating thread.
      // If these threads are different, it returns true.
      if (this->keyNumber->InvokeRequired)
      {
         SetKeyTextCallback *d  = new SetKeyTextCallback(this, &NETMonitor::Form1::SetKeyText);
         System::Object* args[] = {__box(key)};
         this->Invoke(d, args);
      }
      else
      {
         if (keyboard->IsKeyDown(key))
            this->keyNumber->Text = key.ToString();
         else
            this->keyNumber->Clear();
      }
   }

   void device_DeviceChange(int reserved)
   {
      SetDeviceText();
   }

   void sensor_SensorInput(void)
   {
      SetMotionTexts();
   }

   void keyboard_KeyDown(int key)
   {
      SetKeyText(key);
   }

   void keyboard_KeyUp(int key)
   {
      SetKeyText(key);
   }

};
}


