/*----------------------------------------------------------------------
*  math3d.cpp -- 3d maths implementation file
*
*----------------------------------------------------------------------
*
* (c) 1998-2007 3Dconnexion. All rights reserved. 
* Permission to use, copy, modify, and distribute this software for all
* purposes and without fees is hereby grated provided that this copyright
* notice appears in all copies.  Permission to modify this software is granted
* and 3Dconnexion will support such modifications only is said modifications are
* approved by 3Dconnexion.
*
*/
#include "stdafx.h"
#include "math3d.h"
#include <cmath>


void MathFrameTranslation( MathFrame *Frame, real X, real Y, real Z )
{
   Frame->MathTranslation[0] = -X;
   Frame->MathTranslation[1] = -Y;
   Frame->MathTranslation[2] = Z;
}

void MathFrameRotation( MathFrame *Frame, real Roll, real Pitch, real Yaw )
{
   real sa,ca, sb,cb, sc,cc;
   real sacc, casc, sasc, cacc;

   sa = (real)-sin(Yaw);	 ca = (real) cos(Yaw);
   sb = (real)-sin(Pitch); cb = (real) cos(Pitch);
   sc = (real) sin(Roll);	 cc = (real) cos(Roll);

   Frame->MathRotation[0][0] = ca*cb;
   Frame->MathRotation[1][0] =-sa*cb;
   Frame->MathRotation[2][0] = -sb;

   sacc = sa*cc;
   casc = ca*sc;
   sasc = sa*sc;
   cacc = ca*cc;

   Frame->MathRotation[0][1] = sacc - casc*sb;
   Frame->MathRotation[1][1] = cacc + sasc*sb;
   Frame->MathRotation[2][1] = -cb*sc;

   Frame->MathRotation[0][2] = sasc + cacc*sb;
   Frame->MathRotation[1][2] = casc - sacc*sb;
   Frame->MathRotation[2][2] = cb*cc;

}

void MathFrameMultiplication( MathFrame *FrameA, MathFrame *FrameB, MathFrame *FrameAB )
{
   MathFrame FrameResult;
   int m,n,k;

   for ( m=0; m<FRAMEROTm; ++m )
      for ( n=0; n<FRAMEROTn; ++n )
      {
         FrameResult.MathRotation[m][n] = (real) 0.0;
         for ( k=0; k<FRAMEROTn; ++k )
            FrameResult.MathRotation[m][n] += FrameA->MathRotation[m][k] *
            FrameB->MathRotation[k][n];
      };
   for ( m=0; m<FRAMETRA; ++m )
      FrameResult.MathTranslation[m] = FrameA->MathTranslation[m] +
      FrameB->MathTranslation[m];
   memcpy( FrameAB, &FrameResult, sizeof( FrameResult ) );
}

void MathFrameTransformation( MathFrame *Frame, MathPoint *PointIn, MathPoint *PointOut )
{
   MathPoint PointResult;
   int m,n;

   for ( m=0; m<FRAMEROTm; ++m )
   {
      PointResult.MathTranslation[m] = Frame->MathTranslation[m];
      for ( n=0; n<FRAMEROTn; ++n )
         PointResult.MathTranslation[m] += Frame->MathRotation[m][n] * PointIn->MathTranslation[n];
   };
   memcpy( PointOut, &PointResult, sizeof( PointResult ) );
}

void MathVectorSubtraction( MathPoint *Point1, MathPoint *Point2, MathPoint *Vector )
{
   Vector->MathTranslation[0] = Point1->MathTranslation[0] - Point2->MathTranslation[0];
   Vector->MathTranslation[1] = Point1->MathTranslation[1] - Point2->MathTranslation[1];
   Vector->MathTranslation[2] = Point1->MathTranslation[2] - Point2->MathTranslation[2];
}

real MathVectorScalar( MathPoint *Point1, MathPoint *Point2 )
{
   return Point1->MathTranslation[0]*Point2->MathTranslation[0] +
      Point1->MathTranslation[1]*Point2->MathTranslation[1] +
      Point1->MathTranslation[2]*Point2->MathTranslation[2];
}

void MathVectorProduct( MathPoint *Point1, MathPoint *Point2, MathPoint *Product )
{
   MathPoint ProductResult;

   ProductResult.MathTranslation[0] = Point1->MathTranslation[1] *
      Point2->MathTranslation[2] -
      Point1->MathTranslation[2] *
      Point2->MathTranslation[1];
   ProductResult.MathTranslation[1] = Point1->MathTranslation[2] *
      Point2->MathTranslation[0] -
      Point1->MathTranslation[0] *
      Point2->MathTranslation[2];
   ProductResult.MathTranslation[2] = Point1->MathTranslation[0] *
      Point2->MathTranslation[1] -
      Point1->MathTranslation[1] *
      Point2->MathTranslation[0];
   memcpy( Product, &ProductResult, sizeof( ProductResult ) );
}

void Math2DTransformation( MathPoint *PointIn, MathPoint *PointOut, real Focus )
{
   PointOut->MathTranslation[0] = Focus * PointIn->MathTranslation[0] / PointIn->MathTranslation[2];
   PointOut->MathTranslation[1] = Focus * PointIn->MathTranslation[1] / PointIn->MathTranslation[2];
   PointOut->MathTranslation[2] = (real) 0.0;
}

void Math2DCoordinate( MathPoint *PointIn, MathPoint *PointOut, MathVideo *Parameter )
{
   PointOut->MathTranslation[0] = PointIn->MathTranslation[0] *
      Parameter->VideoMaxX * Parameter->VideoRatio +
      Parameter->VideoMaxX/2;
   PointOut->MathTranslation[1] =-PointIn->MathTranslation[1] *
      Parameter->VideoMaxY +
      Parameter->VideoMaxY/2;
   PointOut->MathTranslation[2] = 0.0;
}



