// MainFrm.cpp : implementation of the CMainFrame class
//

#include "stdafx.h"
#include "MFCCube3d.h"

#include "MainFrm.h"
#include "math3d.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif

extern HDC hHiddenDC;
extern HBITMAP hHiddenBitMap;
extern MathVideo VGAVideo;
extern MathFrame FrameCube;

// CMainFrame

IMPLEMENT_DYNAMIC(CMainFrame, CFrameWnd)

BEGIN_MESSAGE_MAP(CMainFrame, CFrameWnd)
	ON_WM_CREATE()
	ON_WM_SETFOCUS()
	ON_WM_NCDESTROY()
END_MESSAGE_MAP()

static UINT indicators[] =
{
	ID_SEPARATOR,           // status line indicator
	ID_INDICATOR_CAPS,
	ID_INDICATOR_NUM,
	ID_INDICATOR_SCRL,
};


// CMainFrame construction/destruction

CMainFrame::CMainFrame()
{
	// TODO: add member initialization code here
}

CMainFrame::~CMainFrame()
{
}

#define WINDOWWIDTH 808
#define WINDOWHEIGHT 646
#define _3DxVersion	_T(" 3Dconnexion 2007")


int CMainFrame::OnCreate(LPCREATESTRUCT lpCreateStruct)
{

	if (CFrameWnd::OnCreate(lpCreateStruct) == -1)
      return -1;

   HWND hDesktopWnd = ::GetDesktopWindow();
   HDC hcaps = ::GetDC(hDesktopWnd);
   int DisplayWidth  = GetDeviceCaps(hcaps,HORZRES);
   int DisplayHeight = GetDeviceCaps(hcaps,VERTRES);
   ::ReleaseDC(hDesktopWnd, hcaps); 
   hcaps = NULL;

   int xpos= (DisplayWidth  - WINDOWWIDTH ) /2;
   int ypos= (DisplayHeight - WINDOWHEIGHT) /2;

   SetWindowPos (NULL, xpos, ypos, WINDOWWIDTH, WINDOWHEIGHT, SWP_NOZORDER);


	// create a view to occupy the client area of the frame
	if (!m_wndView.Create(NULL, NULL, AFX_WS_DEFAULT_VIEW,
		CRect(0, 0, 0, 0), this, AFX_IDW_PANE_FIRST, NULL))
	{
		TRACE0("Failed to create view window\n");
		return -1;
	}
	
	if (!m_wndToolBar.CreateEx(this, TBSTYLE_FLAT, WS_CHILD | WS_VISIBLE | CBRS_TOP
		| CBRS_GRIPPER | CBRS_TOOLTIPS | CBRS_FLYBY | CBRS_SIZE_DYNAMIC) ||
		!m_wndToolBar.LoadToolBar(IDR_MAINFRAME))
	{
		TRACE0("Failed to create toolbar\n");
		return -1;      // fail to create
	}

	if (!m_wndStatusBar.Create(this) ||
		!m_wndStatusBar.SetIndicators(indicators,
		  sizeof(indicators)/sizeof(UINT)))
	{
		TRACE0("Failed to create status bar\n");
		return -1;      // fail to create
	}
	// TODO: Delete these three lines if you don't want the toolbar to be dockable
	m_wndToolBar.EnableDocking(CBRS_ALIGN_ANY);
	EnableDocking(CBRS_ALIGN_ANY);
	DockControlBar(&m_wndToolBar);

   HRESULT hr = InitializeCOM();
   if (!SUCCEEDED(hr))
   {
      // stop creation of window
      return -1;
   }


	return 0;
}

BOOL CMainFrame::PreCreateWindow(CREATESTRUCT& cs)
{
	if( !CFrameWnd::PreCreateWindow(cs) )
		return FALSE;
	// TODO: Modify the Window class or styles here by modifying
	//  the CREATESTRUCT cs

	cs.style = WS_OVERLAPPED | WS_CAPTION | FWS_ADDTOTITLE
		 | WS_THICKFRAME | WS_MINIMIZEBOX | WS_SYSMENU;

	cs.dwExStyle &= ~WS_EX_CLIENTEDGE;
	cs.lpszClass = AfxRegisterWndClass(0);
	return TRUE;
}


// CMainFrame diagnostics

#ifdef _DEBUG
void CMainFrame::AssertValid() const
{
	CFrameWnd::AssertValid();
}

void CMainFrame::Dump(CDumpContext& dc) const
{
	CFrameWnd::Dump(dc);
}

#endif //_DEBUG


// CMainFrame message handlers

void CMainFrame::OnSetFocus(CWnd* /*pOldWnd*/)
{
	// forward focus to the view window
   if (m_wndView.IsFrameWnd())
	   m_wndView.SetFocus();
}

BOOL CMainFrame::OnCmdMsg(UINT nID, int nCode, void* pExtra, AFX_CMDHANDLERINFO* pHandlerInfo)
{
	// let the view have first crack at the command
	if (m_wndView.OnCmdMsg(nID, nCode, pExtra, pHandlerInfo))
		return TRUE;

	// otherwise, do default handling
	return CFrameWnd::OnCmdMsg(nID, nCode, pExtra, pHandlerInfo);
}


void CMainFrame::OnNcDestroy()
{
   UninitializeCOM();
   __super::OnNcDestroy();
}

HRESULT CMainFrame::InitializeCOM()
{
   HRESULT hr;
   CComPtr<IUnknown> _3DxDevice;

   // Create the device object
   hr = _3DxDevice.CoCreateInstance(__uuidof(Device));
   if (SUCCEEDED(hr))
   {

      CComPtr<ISimpleDevice> _3DxSimpleDevice;

      hr = _3DxDevice.QueryInterface(&_3DxSimpleDevice);


      if (SUCCEEDED(hr))
      {

         // Set the preferences we want to use
         _3DxSimpleDevice->LoadPreferences(L"AtlCude3D");

         hr = __hook(&_ISimpleDeviceEvents::DeviceChange, 
                        _3DxSimpleDevice, 
                        &CMainFrame::OnDeviceChange,
                        this);

         // Get the interfaces to the sensor and the keyboard;
         hr = _3DxSimpleDevice->get_Sensor(&m_pISensor);

         hr = __hook(&_ISensorEvents::SensorInput, m_pISensor, 
                        &CMainFrame::OnSensorInput);

         hr = _3DxSimpleDevice->get_Keyboard(&m_pIKeyboard);

         hr = __hook(&_IKeyboardEvents::KeyDown, m_pIKeyboard, 
                        &CMainFrame::OnKeyDown);

         hr = __hook(&_IKeyboardEvents::KeyUp, m_pIKeyboard, 
                        &CMainFrame::OnKeyUp);

         // Connect to the driver
         _3DxSimpleDevice->Connect();
      }
      _3DxDevice.Release();
   }
   else
      ::MessageBox (NULL, 
                     _T("Could not create Device"),
                     _T("CoCreateInstance failed"), 
                     MB_ICONERROR|MB_OK);


   return hr;
}
HRESULT CMainFrame::OnDeviceChange(long reserved )
{
   HRESULT result = S_OK;
   AtlTrace (_T("CCubeWindow::OnDeviceChange(reserved =0x%x)\n"), reserved);

   HRESULT hr;
   ISimpleDevicePtr _p3DxDevice;
   hr = m_pIKeyboard->get_Device((IDispatch**)&_p3DxDevice);
   if (SUCCEEDED(hr))
   {
      long device;
      _p3DxDevice->get_Type(&device);
      AtlTrace (_T("Attached device=%d\n"), device);
      _p3DxDevice.Release();

      long keys, programmableKeys;
      m_pIKeyboard->get_Keys(&keys);
      m_pIKeyboard->get_ProgrammableKeys(&programmableKeys);
      AtlTrace (_T("Number of Keys=%d\tProgrammable keys=%d\n"), keys, programmableKeys);
      for (long i=1; i<=keys; i++)
      {
         BSTR bstrLabel;
         BSTR bstrName;
         m_pIKeyboard->GetKeyLabel(i, &bstrLabel);
         m_pIKeyboard->GetKeyName(i, &bstrName);

         CString strLabel(bstrLabel);
         CString strName(bstrName);

         AtlTrace (_T("Key Label=%s\tKey Name=%s\n"), (const TCHAR *)strLabel, (const TCHAR *)strName);
      }
   }
   return result;
}

HRESULT CMainFrame::OnKeyDown(int keyCode )
{
   HRESULT result = S_OK;
   AtlTrace (_T("CCubeWindow::OnKeyDown(keyCode =%d)\n"), keyCode);
   switch (keyCode)
   {
   case 31: // Fit
      MathFrameTranslation( &FrameCube, 0.0, 0.0, -10. );
      MathFrameRotation( &FrameCube, 0., 0., 0. );
      m_wndView.RedrawWindow(NULL, NULL, RDW_INVALIDATE);
      break;
   }
   return result;
}

HRESULT CMainFrame::OnKeyUp(int keyCode )
{
   HRESULT result = S_OK;
   AtlTrace (_T("CCubeWindow::OnKeyUp(keyCode =%d)\n"), keyCode);
   return result;
}

#define ScaleRotation		1024.0
#define ScaleTranslation	512.0
#define NearPosition		   -2.0
#define Sensitivity        1.0

HRESULT CMainFrame::OnSensorInput(void)
{
   HRESULT result = S_OK;
   static DWORD s_dwLastDraw = 0;

   AtlTrace (_T("CCubeWindow::OnSensorInput()\n"));
   try {
      CComPtr<IAngleAxis> pRotation;
      HRESULT hr = m_pISensor->get_Rotation(&pRotation);

      double angle;
      pRotation->get_Angle(&angle);


      CComPtr<IVector3D> pTranslation;
      hr = m_pISensor->get_Translation(&pTranslation);
      
 
      double length;
      pTranslation->get_Length(&length);

      if (angle > 0. || length > 0.)
      {
         MathFrame FrameTransRot;
         double x, y, z;
         double timeFactor = 1.;

         DWORD dwNow = ::GetTickCount();
         if (s_dwLastDraw)
         {
            double period;
            m_pISensor->get_Period(&period);
            timeFactor = (double)(dwNow-s_dwLastDraw)/period;
         }
         s_dwLastDraw = dwNow;



         length *= timeFactor;
         length /= ScaleTranslation*Sensitivity;
         pTranslation->put_Length(length);
         pTranslation->get_X(&x);
         pTranslation->get_Y(&y);
         pTranslation->get_Z(&z);
         MathFrameTranslation(&FrameTransRot, x, y, z);


         pRotation->get_X(&x);
         pRotation->get_Y(&y);
         pRotation->get_Z(&z);

         angle *= timeFactor;
         angle /= ScaleRotation*Sensitivity;
         MathFrameRotation( &FrameTransRot, 
                     x * angle, 
                     y * angle,
                     z * angle );

         MathFrameMultiplication( &FrameTransRot, &FrameCube, &FrameCube );
         if ( FrameCube.MathTranslation[2] > NearPosition )
            FrameCube.MathTranslation[2] = NearPosition;

         m_wndView.RedrawWindow(NULL, NULL, RDW_INVALIDATE);
      }
      else
         s_dwLastDraw = 0;

      pRotation.Release();
      pTranslation.Release();
   }
   catch (...)
   {
      // Some sort of exception handling
   }

   return result;
}

HRESULT CMainFrame::UninitializeCOM()
{
   HRESULT hr = E_FAIL;

   CComPtr<IDispatch> _3DxDevice;
   if (m_pISensor)
      hr = m_pISensor->get_Device(&_3DxDevice);

   else if (m_pIKeyboard)
      hr = m_pIKeyboard->get_Device(&_3DxDevice);

   if (SUCCEEDED(hr))
   {
      CComPtr<ISimpleDevice> _3DxSimpleDevice;
      hr = _3DxDevice.QueryInterface(&_3DxSimpleDevice);
      if (SUCCEEDED(hr))
      {
         __unhook(&_ISimpleDeviceEvents::DeviceChange, 
                        _3DxSimpleDevice, 
                        &CMainFrame::OnDeviceChange,
                        this);

         _3DxSimpleDevice->Disconnect();
      }
   }

   if (m_pISensor)
   {
      // unhook (unadvise) the sensor event sink
      __unhook(&_ISensorEvents::SensorInput, m_pISensor, 
                     &CMainFrame::OnSensorInput);

      m_pISensor.Release();
   }

   if (m_pIKeyboard)
   {
      __unhook(&_IKeyboardEvents::KeyDown, m_pIKeyboard, 
                     &CMainFrame::OnKeyDown);

      __unhook(&_IKeyboardEvents::KeyUp, m_pIKeyboard, 
                     &CMainFrame::OnKeyUp);

      m_pIKeyboard.Release();
   }

   return hr;
}
