// ChildView.cpp : implementation of the CChildView class
//

#include "stdafx.h"
#include "MFCCube3d.h"
#include "ChildView.h"
#include "Math3d.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif

#define 	BROWN				RGB(0,255,255)
#define 	YELLOW 			RGB(255,255,0)
#define  GREEN				RGB(0,191,0)
#define  LIGHTRED			RGB(255,0,0)
#define	LIGHTMAGENTA   RGB(191,0,191)
#define	LIGHTBLUE		RGB(0,0,191)

#define CubeSize		1.0

MathPoint P1 = { { +CubeSize, -CubeSize, +CubeSize } };
MathPoint P2 = { { +CubeSize, -CubeSize, -CubeSize } };
MathPoint P3 = { { +CubeSize, +CubeSize, -CubeSize } };
MathPoint P4 = { { +CubeSize, +CubeSize, +CubeSize } };
MathPoint P5 = { { -CubeSize, -CubeSize, +CubeSize } };
MathPoint P6 = { { -CubeSize, -CubeSize, -CubeSize } };
MathPoint P7 = { { -CubeSize, +CubeSize, -CubeSize } };
MathPoint P8 = { { -CubeSize, +CubeSize, +CubeSize } };

MathPlane Pl1 = { { &P4, &P3, &P2, &P1 }, BROWN };
MathPlane Pl2 = { { &P8, &P4, &P1, &P5 }, YELLOW };
MathPlane Pl3 = { { &P8, &P5, &P6, &P7 }, GREEN };
MathPlane Pl4 = { { &P7, &P6, &P2, &P3 }, LIGHTRED };
MathPlane Pl5 = { { &P8, &P7, &P3, &P4 }, LIGHTMAGENTA };
MathPlane Pl6 = { { &P6, &P5, &P1, &P2 }, LIGHTBLUE };

#define FRAMEWIDE 800                   /* width of client area */
#define FRAMEHIGH 600                  /* height of client area */
#define WIDE	FRAMEWIDE
#define HIGH	FRAMEHIGH

HDC hHiddenDC=NULL;
HBITMAP hHiddenBitMap=NULL;
MathVideo VGAVideo = { 8.3/12.3, FRAMEWIDE, FRAMEHIGH, 1.5 };
MathFrame FrameCube;

void DisplayPlane( MathPlane *Plane, MathFrame *Frame, MathVideo *Video )
{
   MathPoint Point3D[ PLANEPOINTS ];
   MathPoint Point2D[ PLANEPOINTS ];
   MathPoint Vector1, Vector2, VectorX;
   int loop;
   POINT Shape[6];
   HBRUSH ColorBrush, PrevBrush;
   HPEN ColorPen, PrevPen;

   for ( loop=0; loop<PLANEPOINTS; ++loop )
   {
      MathFrameTransformation( Frame, Plane->PlanePoints[loop], &Point3D[loop] );
      Math2DTransformation( &Point3D[loop], &Point2D[loop], Video->VideoFocus );
   };
   MathVectorSubtraction( Plane->PlanePoints[3], Plane->PlanePoints[0], &Vector1 );
   MathVectorSubtraction( Plane->PlanePoints[1], Plane->PlanePoints[0], &Vector2 );

   MathVectorSubtraction( &Point2D[3], &Point2D[0], &Vector1 );
   MathVectorSubtraction( &Point2D[1], &Point2D[0], &Vector2 );

   MathVectorProduct( &Vector1, &Vector2, &VectorX );
   if ( VectorX.MathTranslation[2] > (real) 0.0 )
   {
      for ( loop=0; loop<PLANEPOINTS; ++loop )
      {
         Math2DCoordinate( &Point2D[loop], &Point2D[loop], Video );
         Shape[loop].x = (int) Point2D[loop].MathTranslation[0];
         Shape[loop].y = (int) Point2D[loop].MathTranslation[1];
      };

      ColorPen = CreatePen(PS_SOLID,1, RGB(0,0,0) );
      ColorBrush = CreateSolidBrush( Plane->PlaneColor );
      PrevPen = static_cast<HPEN>(SelectObject(hHiddenDC,ColorPen));
      PrevBrush = static_cast<HBRUSH>(SelectObject(hHiddenDC,ColorBrush));

      Polygon( hHiddenDC, Shape, 4 );

      SelectObject(hHiddenDC,PrevPen);
      SelectObject(hHiddenDC,PrevBrush);
      DeleteObject(ColorPen);
      DeleteObject(ColorBrush);
   };
}

int InitHiddenWindow( HWND hWnd )
{
   HDC hDisplayDC;

   GlobalCompact((DWORD)-1L);

   hDisplayDC = GetDC(hWnd);
   hHiddenDC = CreateCompatibleDC(hDisplayDC);

   RECT rect;
   GetClientRect(hWnd, &rect);

   hHiddenBitMap = CreateCompatibleBitmap(hDisplayDC,FRAMEWIDE, FRAMEHIGH);
   if ( hHiddenBitMap == (HBITMAP) NULL )
      return FALSE;
   ReleaseDC( hWnd, hDisplayDC );

   return TRUE;
}

int DeleteHiddenWindow( HWND hWnd )
{
   if ( hHiddenBitMap != (HBITMAP) NULL )
   {
      DeleteObject( hHiddenBitMap );
      hHiddenBitMap = (HBITMAP) NULL;
   };
   if ( hHiddenDC != (HDC) NULL )
   {
      ReleaseDC( hWnd, hHiddenDC );
      hHiddenDC = (HDC) NULL;
   };

   return TRUE;
}

void DisplayCube( HWND hWnd, MathFrame *Frame, MathVideo *Video )
{
   HDC hDisplayDC;

   hDisplayDC = GetDC( hWnd );

   if (hHiddenDC == NULL || hHiddenBitMap == NULL)
      InitHiddenWindow (hWnd);

   SelectObject( hHiddenDC, hHiddenBitMap );
   PatBlt(hHiddenDC,0,0,FRAMEWIDE,FRAMEHIGH,WHITENESS);

   DisplayPlane( &Pl1, Frame, Video );
   DisplayPlane( &Pl2, Frame, Video );
   DisplayPlane( &Pl3, Frame, Video );
   DisplayPlane( &Pl4, Frame, Video );
   DisplayPlane( &Pl5, Frame, Video );
   DisplayPlane( &Pl6, Frame, Video );

   BitBlt( hDisplayDC, 0,0, WIDE,HIGH, hHiddenDC, 0,0, SRCCOPY );

   ReleaseDC( hWnd, hDisplayDC );
}

///////////////////////////////////////////////////////////////////////////////////
// CChildView

CChildView::CChildView()
{
}

CChildView::~CChildView()
{
}


BEGIN_MESSAGE_MAP(CChildView, CWnd)
	ON_WM_PAINT()
	ON_WM_CREATE()
END_MESSAGE_MAP()



// CChildView message handlers

BOOL CChildView::PreCreateWindow(CREATESTRUCT& cs) 
{
	if (!CWnd::PreCreateWindow(cs))
		return FALSE;

	cs.dwExStyle |= WS_EX_CLIENTEDGE;
	cs.style &= ~WS_BORDER;
	cs.lpszClass = AfxRegisterWndClass(CS_HREDRAW|CS_VREDRAW|CS_DBLCLKS, 
		::LoadCursor(NULL, IDC_ARROW), reinterpret_cast<HBRUSH>(COLOR_WINDOW+1), NULL);

	return TRUE;
}

int CChildView::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
   int result = __super::OnCreate(lpCreateStruct);
   SetCursor( LoadCursor((HINSTANCE)NULL,IDC_WAIT) );

   InitHiddenWindow(m_hWnd);
   MathFrameTranslation( &FrameCube, 0.0, 0.0, -10.0 );
   MathFrameRotation( &FrameCube, 0.0, 0.0, 0.0 );
   UpdateWindow();

   SetCursor( LoadCursor((HINSTANCE)NULL,IDC_ARROW) );

   return result;

}

void CChildView::OnPaint() 
{
	CPaintDC dc(this); // device context for painting
	
	// TODO: Add your message handler code here
   DisplayCube(m_hWnd, &FrameCube, &VGAVideo);	
	// Do not call CWnd::OnPaint() for painting messages
}

