/*----------------------------------------------------------------------
*  math3d.h
*
*----------------------------------------------------------------------
*
* (c) 1998-2005 3Dconnexion. All rights reserved. 
* Permission to use, copy, modify, and distribute this software for all
* purposes and without fees is hereby grated provided that this copyright
* notice appears in all copies.  Permission to modify this software is granted
* and 3Dconnexion will support such modifications only is said modifications are
* approved by 3Dconnexion.
*
*/
#pragma once

#ifndef TRUE
#define TRUE	(1==1)
#endif

#ifndef FALSE
#define FALSE	(1==0)
#endif

#define Pi	3.14159265358979

typedef double	real;		/* Gleitkomma Zahl */

#define FRAMEROTm	3	/* m x n Rotations Frame */
#define FRAMEROTn	3
#define FRAMETRA	3


struct _MathFrame_ {
   real	MathRotation[FRAMEROTm][FRAMEROTn];
   real	MathTranslation[FRAMETRA];
};
typedef struct _MathFrame_ MathFrame;

struct _MathPoint_ {
   real	MathTranslation[FRAMETRA];
};
typedef	struct _MathPoint_ MathPoint;

#define MathPointX(Frame)	((Frame).MathTranslation[0])
#define MathPointY(Frame)	((Frame).MathTranslation[1])
#define MathPointZ(Frame)	((Frame).MathTranslation[2])

#define PLANEPOINTS		4

struct _MathPlane_ {
   MathPoint *PlanePoints[ PLANEPOINTS ];
   COLORREF PlaneColor;
};
typedef struct _MathPlane_ MathPlane;

struct _MathVideo_ {
   real VideoRatio;
   real VideoMaxX, VideoMaxY;
   real VideoFocus;
};
typedef struct _MathVideo_ MathVideo;


void MathFrameTranslation( MathFrame *, real, real, real );
void MathFrameRotation( MathFrame *, real, real, real );
void MathFrameMultiplication( MathFrame *, MathFrame *, MathFrame *);
void MathFrameTransformation( MathFrame *, MathPoint *, MathPoint *);
void MathVectorSubtraction( MathPoint *, MathPoint *, MathPoint *);
real MathVectorScalar( MathPoint *, MathPoint *);
void MathVectorProduct( MathPoint *, MathPoint *, MathPoint *);
void Math2DTransformation( MathPoint *, MathPoint *, real );
void Math2DCoordinate( MathPoint *, MathPoint *, MathVideo *);



