// AtlCube3d.cpp : Implementation of WinMain


#include "stdafx.h"
#include "resource.h"
#include "AtlCube3d.h"
#include "cubewindow.h"



// The module attribute causes WinMain to be automatically implemented for you
[ module(exe, uuid = "{9575CA39-C674-4F35-9C95-BA3CA7ED1C1C}", 
         name = "AtlCube3d", 
         helpstring = "3Dconnexion AtlCube3d 1.0 Sample",
         resource_name = "IDR_ATLCUBE3D") ]

class CAtlCube3dModule
{
public:
   CAtlCube3dModule() : m_pWindow(NULL)
   {
   }

   virtual ~CAtlCube3dModule()
   {
      if (m_pWindow)
         delete m_pWindow;
      m_pWindow=NULL;
   }

private:
   CCubeWindow* m_pWindow;

public :
   HRESULT PostMessageLoop() throw( )
   {
      HRESULT hr = S_OK;
      if (m_pWindow)
      {
         delete m_pWindow;
         m_pWindow = NULL;
      }
      return hr;
   }

   HRESULT PreMessageLoop(int nShowCmd) throw( )
   {
      HRESULT hr = E_FAIL;
      m_pWindow = new CCubeWindow();
      if (m_pWindow)
      {
         if (m_pWindow->Create(NULL))
         {
            m_pWindow->ShowWindow(nShowCmd);
            hr = S_OK;
         }
         else
         {
            AtlTrace (_T("CreateWindow() failed with error = %d\n"), GetLastError());
            delete m_pWindow;
            m_pWindow = NULL;
         }
      }
      return hr;
   }
};

