// CubeWindow.h : Declaration of the CCubeWindow
/*
* (c) 1998-2006 3Dconnexion. All rights reserved. 
* Permission to use, copy, modify, and distribute this software for all
* purposes and without fees is hereby grated provided that this copyright
* notice appears in all copies.  Permission to modify this software is granted
* and 3Dconnexion will support such modifications only is said modifications are
* approved by 3Dconnexion.
*
*/
#pragma once
///////////////////////////////////////////////////////////////////////////////////
// History
//
// $Id: CubeWindow.h 2579 2006-12-14 08:04:45Z markus_bonk $
//
// 05.12.06 MSB Initial Design
//
#include "resource.h"       // main symbols
#include <atlwin.h>

// CCubeWindow
[ event_receiver(com) ]
class CCubeWindow : 
	public CWindowImpl<CCubeWindow, CWindow, CFrameWinTraits>
{
public:
	CCubeWindow()
	{
      INITCOMMONCONTROLSEX initCtrls = {sizeof(initCtrls), ICC_WIN95_CLASSES |ICC_STANDARD_CLASSES};
      InitCommonControlsEx( &initCtrls);
	}

	~CCubeWindow()
	{
	}

private:
   HMENU m_hmenu;

#if 1
   CComPtr<ISensor> m_pISensor;
   CComPtr<IKeyboard> m_pIKeyboard;
#else
   ISensorPtr m_pISensor;
   IKeyboardPtr m_pIKeyboard;
#endif

public:

BEGIN_MSG_MAP(CCubeWindow)
   MESSAGE_HANDLER (WM_CREATE, OnCreate)
   MESSAGE_HANDLER (WM_NCDESTROY, OnNcDestroy)
   MESSAGE_HANDLER (WM_PAINT, OnPaint)
   COMMAND_HANDLER (IDM_About, 0, OnAbout)
   COMMAND_HANDLER (IDM_Exit, 0, OnExit)
END_MSG_MAP()

// Handler prototypes:
//  LRESULT MessageHandler(UINT uMsg, WPARAM wParam, LPARAM lParam, BOOL& bHandled);
//  LRESULT CommandHandler(WORD wNotifyCode, WORD wID, HWND hWndCtl, BOOL& bHandled);
//  LRESULT NotifyHandler(int idCtrl, LPNMHDR pnmh, BOOL& bHandled);

   LRESULT OnCreate(UINT uMsg, WPARAM wParam, LPARAM lParam, BOOL& bHandled);
   LRESULT OnNcDestroy(UINT uMsg, WPARAM wParam, LPARAM lParam, BOOL& bHandled);
   LRESULT OnPaint(UINT uMsg, WPARAM wParam, LPARAM lParam, BOOL& bHandled);
   LRESULT OnAbout(WORD wNotifyCode, WORD wID, HWND hWndCtl, BOOL& bHandled);
   LRESULT OnExit(WORD wNotifyCode, WORD wID, HWND hWndCtl, BOOL& bHandled);


// COM Event handlers
   HRESULT InitializeCOM();
   HRESULT OnDeviceChange (long reserved);
   HRESULT OnKeyDown (int keyCode);
   HRESULT OnKeyUp (int keyCode);
   HRESULT OnSensorInput(void);
   HRESULT UninitializeCOM();
 
};


