/**
 * Copyright (c) 2025 3Dconnexion. All rights reserved.
 * License:
 *   This file in licensed under the terms of the '3Dconnexion
 *   Software Development Kit' license agreement found in the
 *   'LicenseAgreementSDK.txt' file.
 *   All rights not expressly granted by 3Dconnexion are reserved.
 *
 */

/**
 * Entry point for the 2D SpaceMouse sample application.
 *
 * Initializes the `ViewportEx` instance, loads the sample image and wires
 * a UI button to trigger a zoom-to-extents action.
 *
 * @file
 */
import { ViewportEx } from "./viewportex.js";

/**
 * Initialize the sample when the window finishes loading.
 *
 * @returns {void}
 */
window.onload = () => {
    const viewport = new ViewportEx("theImage");

    viewport.loadImage("Images/SpaceMouseWireless-Kit.jpg");

    let button = document.getElementById("zoomExtents");

    button.addEventListener("click", () => viewport.zoomExtents());
};
