/**
 * Copyright (c) 2025 3Dconnexion. All rights reserved.
 * License:
 *   This file in licensed under the terms of the '3Dconnexion
 *   Software Development Kit' license agreement found in the
 *   'LicenseAgreementSDK.txt' file.
 *   All rights not expressly granted by 3Dconnexion are reserved.
 *
 */
import { Viewport } from "./viewport.js";

/**
 * Initialize the sample when the window finishes loading.
 *
 * @returns {void}
 */
window.onload = () => {
    const viewport = new Viewport("theImage");

    viewport.loadImage("images/SpaceMouseWireless-Kit.jpg");

    let button = document.getElementById("zoomExtents");

    button.addEventListener("click", () => viewport.zoomExtents());
};
