/**
 * Copyright (c) 2025 3Dconnexion. All rights reserved.
 * License:
 *   This file in licensed under the terms of the '3Dconnexion
 *   Software Development Kit' license agreement found in the
 *   'LicenseAgreementSDK.txt' file.
 *   All rights not expressly granted by 3Dconnexion are reserved.
 *
 */
/**
 * Navigation interface expected by the navigation layer.
 * This is a JSDoc interface so editors / tsc (with checkJs) can type-check.
 *
 * @typedef {Object} INavigation2d
 */

/**
 * Return the focusable element used to determine spacemouse focus
 * @property
 * @name INavigation2d#focusable
 * @returns {HTMLElement}
 */

/**
 * Return the string used to identify the 3Dconnexion settings file.
 * @property
 * @name INavigation2d#title
 * @returns {string}
 */

/**
 * Return the viewport height in pixels.
 * @property
 * @name INavigation2d#height
 * @returns {number}
 */

/**
 * Return the viewport width in pixels.
 * @property
 * @name INavigation2d#width
 * @returns {number}
 */

/**
 * Return the timing source for the spacemouse events
 * Setting timingSource to 0 (the default value) will instruct the driver to
 * attempt to sync to the monitor vsync for each frame. In that case the frame
 * should be drawn when a frame transaction ends.
 * If an animation loop is used setting timingSource to 1 will update the
 * spacemouse data when it is polled.
 * @property
 * @name INavigation2d#timingSource
 * @returns {number}
 */

/**
 * Callback when the 3dmouse has been created.
 * This is the place to finalize the initialization and export commands and their
 * associated images fro mapping to spacemouse buttons.
 * @function
 * @name INavigation2d#on3dmouseCreated
 */

/**
 * Callback when the 3dmouse connection closes.
 * @function
 * @name INavigation2d#onDisconnect
 * @param {string} reason - Disconnect reason supplied by the driver.
 */

/**
 * Initiate navigation driven animation/rendering.
 * @function
 * @name INavigation2d#onStartMotion
 */

/**
 * End navigation driven animation/rendering.
 * @function
 * @name INavigation2d#onStopMotion
 */

/**
 * Gets the bounds of the image being displayed.
 * @function
 * @name INavigation2d#getImageBounds
 * @returns {DOMRect}
 */

/**
 * Gets the viewport scaling factor.
 * @function
 * @name INavigation2d#getScale
 * @returns {number}
 */

/**
 * Gets the current transformation matrix being applied to the viewport.
 * @function
 * @name INavigation2d#getTransform
 * @returns {DOMMatrix}
 */

/**
 * Gets the current pointer position in world/image coordinates.
 * @function
 * @name INavigation2d#getPointerPosition
 * @returns {DOMPoint}
 */

/**
 * Initiate a render request.
 * @function
 * @name INavigation2d#draw
 */
