# PanZoom 2D SpaceMouse Sample

## Quick start guide for adding Spacemouse Support
1. Copy `navigation2d.js` and `inavigation2d.js` to your project and adjust the coordinate system mapping if it doesn't match that of your viewport.
2. Write an extension to your viewport class see `viewportex.js` that implements the `INavigation2D` interface.
3. Create an instance of the `NavigationModel2D` class in your `ViewportEx` instance.

The PanZoom sample demonstrates the above steps and shows how to integrate a 2D canvas image viewer with the 3Dconnexion JavaScript driver so that a 3Dconnexion SpaceMouse can pan, zoom and roll a 2D image.

The sample exposes a minimal navigation adapter that translates controller transactions into simple 2D viewport operations (pan/scale/roll) while preserving the application's normal mouse interactions.

## panzoom_mouse2d.html
panzoom_mouse2d is the original 2d mouse only page that hosts a canvas element and a UI button. It loads an image and creates a `Viewport` instance that manages the canvas rendering and user interactions using a 2d mouse.
- Load and display an image in a canvas with correct aspect fit (zoom extents).
- Mouse-driven pan and wheel-zoom (cursor-centered).

## panzoom_spacemouse.html
panzoom_spacemouse is the modified page for use with a SpaceMouse. It loads an image and creates a `ViewportEx` instance that manages the canvas rendering and user interactions using a 2d mouse as well as a SpaceMouse.
- - SpaceMouse-driven navigation:
  - Continuous pan (X/Y axes)
  - Cursor-aware quick zoom
  - Roll (rotation) about a pivot using the auto pivot algorithms.
- Exposes action buttons and images to the 3Dconnexion properties UI.

## Key files
- `panzoom_mouse2d.html` — Sample host page.
- `scripts/mouse2d.js` — Entry point: creates the viewport instance, wires the UI button and loads the image.
- `scripts/viewport.js` — Core canvas image viewer: pan, scale, roll, zoomExtents, loadImage.

- `panzoom_spacemouse.html` — Modified `panzoom_mouse2d.html` host page.
- `scripts/spacemouse2d.js` — Entry point: creates the `ViewportEx`, wires the UI button and loads the image.
- `scripts/viewportex.js` — Defines ViewportEx that extends the original `Viewport` class and implements the navigation interface used by the driver.
- `scripts/navigation2d.js` — A drop-in adapter between `3DconnexionJS` implementing the driver callbacks and translating them to viewport operations for the `ViewportEx` class.
- `scripts/inavigation2d.js` — Interface describing the navigation contract.
- `node_modules/` — dependencies: `@3dconnexion/3dconnexionjs` and `gl-matrix` (ES module imports).

## Running the samples
1. Ensure all dependencies are installed. The JavaScript modules can be installed by executing `npm install` in the spacemouse2d directory. The `panzoom_spacemouse.html` also requires  that the 3Dconnexion driver is installed.
2. Copy the configuration file `Spacemouse2d.xml` for the sample to `%appdata%/3Dconnexion/3Dxware/Cfg`.
3. Connect a 3Dconnexion device and start the 3DxWare driver.
4. Serve the sample over HTTP (ES module imports and driver RPCs require a web server). You can use any static server or open the project in Visual Studio 2022, open the `panzoom_spacemouse.html` file in the editor and run the web project.
   - In Visual Studio press __F5__ to run the web host (or use your preferred local web server).
5. The sample will register commands and images with the driver. Use the spacemouse to pan/zoom/roll the image.
6. Use the "Zoom Extents" button in the UI to fit the image to the canvas.

## Notes
- The sample uses ES module imports and expects a web server (file:// may fail).
- The 3Dconnexion JavaScript driver communicates via WAMP RPC; make sure the driver and 3DxWare are installed and running.
- The sample is intentionally minimal and focuses on demonstrating navigation integration rather than a full-featured image editor.
- To use an alternative axis mapping for panning and zooming copy the supplied `Spacemouse2d_alt.xml` to `%appdata%/3Dconnexion/3Dxware/Cfg` and remove `Spacemouse2d.xml`. The former configuration file maps left/right to x, forward/backward to y, and rotations about the device up axis to zoom.

## License
See the file header comments in each source file. This sample is distributed under the 3Dconnexion Software Development Kit license referenced in the source headers. The license includes an attribution clause.
