(function (root, factory) {
    if (typeof define === 'function' && define.amd) {
        // AMD: define module and inject autobahn
        define(['autobahn'], factory);
    } else if (typeof module === 'object' && module.exports) {
        // CommonJS / Node
        module.exports = factory(require('autobahn'));
    } else {
        // Browser global
        root._3Dconnexion = factory(root.autobahn);
    }
}(typeof globalThis !== 'undefined' ? globalThis : this, function (autobahnjs) {
    'use strict';

    const result = (typeof _3Dconnexion !== 'undefined') ? _3Dconnexion : root?._3Dconnexion;

    if (typeof (wamp_impl != 'undefined')) {
        wamp_impl = autobahnjs;
    }

    return result;
}));
