/**
 * @license CryptoJS v4.2.0
 * https://cryptojs.gitbook.io/docs/
 * https://github.com/brix/crypto-js
 *
 * CryptoJS JavaScript library of crypto standards.
 * Version 4.2.0
 *
 * [The MIT License (MIT)](http://opensource.org/licenses/MIT)
 *
 * Copyright (c) 2009-2013 Jeff Mott
 * Copyright (c) 2013-2016 Evan Vosberg
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 *
 */
var CryptoJS=CryptoJS||function(n,t){var i;if(typeof window!="undefined"&&window.crypto&&(i=window.crypto),typeof self!="undefined"&&self.crypto&&(i=self.crypto),typeof globalThis!="undefined"&&globalThis.crypto&&(i=globalThis.crypto),!i&&typeof window!="undefined"&&window.msCrypto&&(i=window.msCrypto),!i&&typeof global!="undefined"&&global.crypto&&(i=global.crypto),!i&&typeof require=="function")try{i=require("crypto")}catch(p){}var c=function(){if(i){if(typeof i.getRandomValues=="function")try{return i.getRandomValues(new Uint32Array(1))[0]}catch(n){}if(typeof i.randomBytes=="function")try{return i.randomBytes(4).readInt32LE()}catch(n){}}throw new Error("Native crypto module could not be used to get secure random number.");},l=Object.create||function(){function n(){}return function(t){var i;return n.prototype=t,i=new n,n.prototype=null,i}}(),f={},e=f.lib={},r=e.Base=function(){return{extend:function(n){var t=l(this);return n&&t.mixIn(n),t.hasOwnProperty("init")&&this.init!==t.init||(t.init=function(){t.$super.init.apply(this,arguments)}),t.init.prototype=t,t.$super=this,t},create:function(){var n=this.extend();return n.init.apply(n,arguments),n},init:function(){},mixIn:function(n){for(var t in n)n.hasOwnProperty(t)&&(this[t]=n[t]);n.hasOwnProperty("toString")&&(this.toString=n.toString)},clone:function(){return this.init.prototype.extend(this)}}}(),u=e.WordArray=r.extend({init:function(n,i){n=this.words=n||[];this.sigBytes=i!=t?i:n.length*4},toString:function(n){return(n||a).stringify(this)},concat:function(n){var f=this.words,e=n.words,r=this.sigBytes,u=n.sigBytes,t,o,i;if(this.clamp(),r%4)for(t=0;t<u;t++)o=e[t>>>2]>>>24-t%4*8&255,f[r+t>>>2]|=o<<24-(r+t)%4*8;else for(i=0;i<u;i+=4)f[r+i>>>2]=e[i>>>2];return this.sigBytes+=u,this},clamp:function(){var i=this.words,t=this.sigBytes;i[t>>>2]&=4294967295<<32-t%4*8;i.length=n.ceil(t/4)},clone:function(){var n=r.clone.call(this);return n.words=this.words.slice(0),n},random:function(n){for(var t=[],i=0;i<n;i+=4)t.push(c());return new u.init(t,n)}}),o=f.enc={},a=o.Hex={stringify:function(n){for(var r,u=n.words,f=n.sigBytes,i=[],t=0;t<f;t++)r=u[t>>>2]>>>24-t%4*8&255,i.push((r>>>4).toString(16)),i.push((r&15).toString(16));return i.join("")},parse:function(n){for(var i=n.length,r=[],t=0;t<i;t+=2)r[t>>>3]|=parseInt(n.substr(t,2),16)<<24-t%8*4;return new u.init(r,i/2)}},s=o.Latin1={stringify:function(n){for(var r,u=n.words,f=n.sigBytes,i=[],t=0;t<f;t++)r=u[t>>>2]>>>24-t%4*8&255,i.push(String.fromCharCode(r));return i.join("")},parse:function(n){for(var i=n.length,r=[],t=0;t<i;t++)r[t>>>2]|=(n.charCodeAt(t)&255)<<24-t%4*8;return new u.init(r,i)}},v=o.Utf8={stringify:function(n){try{return decodeURIComponent(escape(s.stringify(n)))}catch(t){throw new Error("Malformed UTF-8 data");}},parse:function(n){return s.parse(unescape(encodeURIComponent(n)))}},h=e.BufferedBlockAlgorithm=r.extend({reset:function(){this._data=new u.init;this._nDataBytes=0},_append:function(n){typeof n=="string"&&(n=v.parse(n));this._data.concat(n);this._nDataBytes+=n.sigBytes},_process:function(t){var h,e=this._data,c=e.words,l=e.sigBytes,o=this.blockSize,a=o*4,r=l/a,i,s,f;if(r=t?n.ceil(r):n.max((r|0)-this._minBufferSize,0),i=r*o,s=n.min(i*4,l),i){for(f=0;f<i;f+=o)this._doProcessBlock(c,f);h=c.splice(0,i);e.sigBytes-=s}return new u.init(h,s)},clone:function(){var n=r.clone.call(this);return n._data=this._data.clone(),n},_minBufferSize:0}),w=e.Hasher=h.extend({cfg:r.extend(),init:function(n){this.cfg=this.cfg.extend(n);this.reset()},reset:function(){h.reset.call(this);this._doReset()},update:function(n){return this._append(n),this._process(),this},finalize:function(n){n&&this._append(n);return this._doFinalize()},blockSize:16,_createHelper:function(n){return function(t,i){return new n.init(i).finalize(t)}},_createHmacHelper:function(n){return function(t,i){return new y.HMAC.init(n,i).finalize(t)}}}),y=f.algo={};return f}(Math),AUTOBAHNJS_VERSION,globalObject;(function(){function u(n,t,r){for(var e=[],f=0,u=0;u<t;u++)if(u%4){var o=r[n.charCodeAt(u-1)]<<u%4*2,s=r[n.charCodeAt(u)]>>>6-u%4*2,h=o|s;e[f>>>2]|=h<<24-f%4*8;f++}return i.create(e,f)}var n=CryptoJS,t=n.lib,i=t.WordArray,r=n.enc,f=r.Base64={stringify:function(n){var u=n.words,e=n.sigBytes,o=this._map,i,t,r,f;for(n.clamp(),i=[],t=0;t<e;t+=3){var s=u[t>>>2]>>>24-t%4*8&255,h=u[t+1>>>2]>>>24-(t+1)%4*8&255,c=u[t+2>>>2]>>>24-(t+2)%4*8&255,l=s<<16|h<<8|c;for(r=0;r<4&&t+r*.75<e;r++)i.push(o.charAt(l>>>6*(3-r)&63))}if(f=o.charAt(64),f)while(i.length%4)i.push(f);return i.join("")},parse:function(n){var o=n.length,r=this._map,i=this._reverseMap,t,f,e;if(!i)for(i=this._reverseMap=[],t=0;t<r.length;t++)i[r.charCodeAt(t)]=t;return f=r.charAt(64),f&&(e=n.indexOf(f),e!==-1&&(o=e)),u(n,o,i)},_map:"ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/="}})(),function(){var n=CryptoJS,t=n.lib,i=t.Base,r=n.enc,u=r.Utf8,f=n.algo,e=f.HMAC=i.extend({init:function(n,t){var r,f,i;n=this._hasher=new n.init;typeof t=="string"&&(t=u.parse(t));r=n.blockSize;f=r*4;t.sigBytes>f&&(t=n.finalize(t));t.clamp();var e=this._oKey=t.clone(),o=this._iKey=t.clone(),s=e.words,h=o.words;for(i=0;i<r;i++)s[i]^=1549556828,h[i]^=909522486;e.sigBytes=o.sigBytes=f;this.reset()},reset:function(){var n=this._hasher;n.reset();n.update(this._iKey)},update:function(n){return this._hasher.update(n),this},finalize:function(n){var t=this._hasher,i=t.finalize(n);return t.reset(),t.finalize(this._oKey.clone().concat(i))}})}(),function(){var n=CryptoJS,i=n.lib,r=i.Base,u=i.WordArray,t=n.algo,f=t.SHA256,e=t.HMAC,o=t.PBKDF2=r.extend({cfg:r.extend({keySize:4,hasher:f,iterations:25e4}),init:function(n){this.cfg=this.cfg.extend(n)},compute:function(n,t){for(var s=this.cfg,r=e.create(s.hasher,n),f=u.create(),l=u.create([1]),p=f.words,w=l.words,a=s.keySize,b=s.iterations,o,c,y,i;p.length<a;){o=r.update(t).finalize(l);r.reset();var v=o.words,k=v.length,h=o;for(c=1;c<b;c++)for(h=r.finalize(h),r.reset(),y=h.words,i=0;i<k;i++)v[i]^=y[i];f.concat(o);w[0]++}return f.sigBytes=a*4,f}});n.PBKDF2=function(n,t,i){return o.create(i).compute(n,t)}}(),function(n){var i=CryptoJS,f=i.lib,s=f.WordArray,r=f.Hasher,h=i.algo,e=[],o=[],t,u;(function(){function u(t){for(var r=n.sqrt(t),i=2;i<=r;i++)if(!(t%i))return!1;return!0}function r(n){return(n-(n|0))*4294967296|0}for(var i=2,t=0;t<64;)u(i)&&(t<8&&(e[t]=r(n.pow(i,1/2))),o[t]=r(n.pow(i,1/3)),t++),i++})();t=[];u=h.SHA256=r.extend({_doReset:function(){this._hash=new s.init(e.slice(0))},_doProcessBlock:function(n,i){for(var r=this._hash.words,f=r[0],s=r[1],h=r[2],y=r[3],e=r[4],a=r[5],v=r[6],p=r[7],u=0;u<64;u++){if(u<16)t[u]=n[i+u]|0;else{var c=t[u-15],b=(c<<25|c>>>7)^(c<<14|c>>>18)^c>>>3,l=t[u-2],k=(l<<15|l>>>17)^(l<<13|l>>>19)^l>>>10;t[u]=b+t[u-7]+k+t[u-16]}var d=e&a^~e&v,g=f&s^f&h^s&h,nt=(f<<30|f>>>2)^(f<<19|f>>>13)^(f<<10|f>>>22),tt=(e<<26|e>>>6)^(e<<21|e>>>11)^(e<<7|e>>>25),w=p+tt+d+o[u]+t[u],it=nt+g;p=v;v=a;a=e;e=y+w|0;y=h;h=s;s=f;f=w+it|0}r[0]=r[0]+f|0;r[1]=r[1]+s|0;r[2]=r[2]+h|0;r[3]=r[3]+y|0;r[4]=r[4]+e|0;r[5]=r[5]+a|0;r[6]=r[6]+v|0;r[7]=r[7]+p|0},_doFinalize:function(){var r=this._data,t=r.words,u=this._nDataBytes*8,i=r.sigBytes*8;return t[i>>>5]|=128<<24-i%32,t[(i+64>>>9<<4)+14]=n.floor(u/4294967296),t[(i+64>>>9<<4)+15]=u,r.sigBytes=t.length*4,this._process(),this._hash},clone:function(){var n=r.clone.call(this);return n._hash=this._hash.clone(),n}});i.SHA256=r._createHelper(u);i.HmacSHA256=r._createHmacHelper(u)}(Math);
/** @license AutobahnJS - http://autobahn.ws
 *
 * Copyright (C) 2011-2014 Tavendo GmbH.
 * Licensed under the MIT License.
 * See license text at http://www.opensource.org/licenses/mit-license.php
 *
 * AutobahnJS includes code from:
 *
 * when - http://cujojs.com
 *
 * (c) copyright B Cavalier & J Hann
 * Licensed under the MIT License at:
 * http://www.opensource.org/licenses/mit-license.php
 *
 * console-normalizer - https://github.com/Zenovations/console-normalizer
 *
 * (c) 2012 by Zenovations.
 * Licensed under the MIT License at:
 * http://www.opensource.org/licenses/mit-license.php
 *
 */
(function(n){n||(n=window.console={log:function(){},info:function(){},warn:function(){},error:function(){}});Function.prototype.bind||(Function.prototype.bind=function(n){var t=this,i=Array.prototype.slice.call(arguments,1);return function(){return t.apply(n,Array.prototype.concat.apply(i,arguments))}});typeof n.log=="object"&&(n.log=Function.prototype.call.bind(n.log,n),n.info=Function.prototype.call.bind(n.info,n),n.warn=Function.prototype.call.bind(n.warn,n),n.error=Function.prototype.call.bind(n.error,n));"group"in n||(n.group=function(t){n.info("\n--- "+t+" ---\n")});"groupEnd"in n||(n.groupEnd=function(){n.log("\n")});"time"in n||function(){var t={};n.time=function(n){t[n]=(new Date).getTime()};n.timeEnd=function(i){var r=(new Date).getTime(),u=i in t?r-t[i]:0;n.info(i+": "+u+"ms")}}()})(window.console);
/** @license MIT License (c) copyright 2011-2013 original author or authors */
globalThis.when=function(n){"use strict";function r(n,t,i,r){return vt(n).then(t,i,r)}function o(n){return new e(n,c.PromiseStatus&&c.PromiseStatus())}function e(n,t){function c(){return r?r.inspect():ri()}function l(n,t,u,f,e){function o(i){i._when(n,t,u,f,e)}i?i.push(o):p(function(){o(r)})}function o(n){if(i){var u=i;i=f;p(function(){r=wt(e,n);t&&kt(r,t);b(u,r)})}}function s(n){o(new u(n))}function a(n){if(i){var t=i;p(function(){b(t,new k(n))})}}var e,r,i=[];e=this;this._status=t;this.inspect=c;this._when=l;try{n(o,s,a)}catch(h){s(h)}}function vt(n){return n instanceof e?n:s(n)}function s(n){return o(function(t){t(n)})}function yt(n){return r(n,function(n){return new u(n)})}function pt(){function r(r,f,e){n.resolve=n.resolver.resolve=function(n){return t?s(n):(t=!0,r(n),i)};n.reject=n.resolver.reject=function(n){return t?s(new u(n)):(t=!0,f(n),i)};n.notify=n.resolver.notify=function(n){return e(n),n}}var n,i,t;return n={promise:f,resolve:f,reject:f,notify:f,resolver:{resolve:f,reject:f,notify:f}},n.promise=i=o(r),n}function b(n,t){for(var i=0;i<n.length;i++)n[i](t)}function wt(n,t){if(t===n)return new u(new TypeError);if(t instanceof e)return t;try{var i=t===Object(t)&&t.then;return typeof i=="function"?bt(i,t):new l(t)}catch(r){return new u(r)}}function bt(n,t){return o(function(i,r){g(n,t,i,r)})}function l(n){this.value=n}function u(n){this.value=n}function k(n){this.value=n}function kt(n,t){function i(){t.fulfilled()}function r(n){t.rejected(n)}n.then(i,r)}function ut(n){return n&&typeof n.then=="function"}function ft(n,t,i,u,f){return r(n,function(n){function e(i,u,f){function y(n){c(n)}function p(n){h(n)}var o,v,s,a,h,c,l,e;if(l=n.length>>>0,o=Math.max(0,Math.min(t,l)),s=[],v=l-o+1,a=[],o)for(c=function(n){a.push(n);--v||(h=c=w,u(a))},h=function(n){s.push(n);--o||(h=c=w,i(s))},e=0;e<l;++e)e in n&&r(n[e],p,y,f);else i(s)}return o(e).then(i,u,f)})}function dt(n,t,i,r){function u(n){return t?t(n[0]):n[0]}return ft(n,1,u,i,r)}function et(n,t,i,r){return a(n,w).then(t,i,r)}function gt(){return a(arguments,w)}function ni(n){return a(n,ot,st)}function ti(n,t){return a(n,t)}function a(n,t,i){return r(n,function(n){function u(u,f,e){function l(n,o){r(n,t,i).then(function(n){s[o]=n;--h||u(s)},f,e)}var s,c,h,o;if(h=c=n.length>>>0,s=[],!h){u(s);return}for(o=0;o<c;o++)o in n?l(n[o],o):--h}return new e(u)})}function ii(n,t){var i=g(d,arguments,1);return r(n,function(n){var u;return u=n.length,i[0]=function(n,i,f){return r(n,function(n){return r(i,function(i){return t(n,i,f,u)})})},ht.apply(n,i)})}function ot(n){return{state:"fulfilled",value:n}}function st(n){return{state:"rejected",reason:n}}function ri(){return{state:"pending"}}function p(n){y.push(n)===1&&h(at)}function at(){b(y);y=[]}function w(n){return n}function ui(n){typeof c.reportUnhandled=="function"?c.reportUnhandled():p(function(){throw n;});throw n;}const t={};t.when=r;t.promise=o;t.resolve=s;t.reject=yt;t.defer=pt;t.join=gt;t.all=et;t.map=ti;t.reduce=ii;t.settle=ni;t.any=dt;t.some=ft;t.isPromise=ut;t.isPromiseLike=ut;i=e.prototype;i.then=function(n,t,i){var r=this;return new e(function(u,f,e){r._when(u,e,n,t,i)},this._status&&this._status.observed())};i["catch"]=i.otherwise=function(n){return this.then(f,n)};i["finally"]=i.ensure=function(n){function t(){return s(n())}return typeof n=="function"?this.then(t,t)["yield"](this):this};i.done=function(n,t){this.then(n,t)["catch"](ui)};i["yield"]=function(n){return this.then(function(){return n})};i.tap=function(n){return this.then(n)["yield"](this)};i.spread=function(n){return this.then(function(t){return et(t,function(t){return n.apply(f,t)})})};i.always=function(n,t){return this.then(n,n,t)};v=Object.create||function(n){function t(){}return t.prototype=n,new t};l.prototype=v(i);l.prototype.inspect=function(){return ot(this.value)};l.prototype._when=function(n,t,i){try{n(typeof i=="function"?i(this.value):this.value)}catch(r){n(new u(r))}};u.prototype=v(i);u.prototype.inspect=function(){return st(this.value)};u.prototype._when=function(n,t,i,r){try{n(typeof r=="function"?r(this.value):this)}catch(f){n(new u(f))}};k.prototype=v(i);k.prototype._when=function(n,t,i,r,u){try{t(typeof u=="function"?u(this.value):this.value)}catch(f){t(f)}};var i,v,ht,d,g,h,y,nt,tt,it,c,ct,rt,lt,f;if(rt=n,y=[],c=typeof console!="undefined"?console:r,typeof process=="object"&&process.nextTick)h=process.nextTick;else if(lt=typeof MutationObserver=="function"&&MutationObserver||typeof WebKitMutationObserver=="function"&&WebKitMutationObserver)h=function(n,t,i){var r=n.createElement("div");return new t(i).observe(r,{attributes:!0}),function(){r.setAttribute("x","x")}}(document,lt,at);else try{h=rt("vertx").runOnLoop||rt("vertx").runOnContext}catch(fi){ct=setTimeout;h=function(n){ct(n,0)}}return nt=Function.prototype,tt=nt.call,g=nt.bind?tt.bind(tt):function(n,t){return n.apply(t,d.call(arguments,2))},it=[],d=it.slice,ht=it.reduce||function(n){var i,u,r,f,t;if(t=0,i=Object(this),f=i.length>>>0,u=arguments,u.length<=1)for(;;){if(t in i){r=i[t++];break}if(++t>=f)throw new TypeError;}else r=u[1];for(;t<f;++t)t in i&&(r=n(r,i[t],t,i));return r},t}();
/** @license MIT License (c) 2011-2013 Copyright Tavendo GmbH. */
AUTOBAHNJS_VERSION="0.8.2.1";globalObject=globalThis,function(n,t){n.ab=t(n,n.when)}(globalObject,function(n,t){"use strict";var i={};return i._version=AUTOBAHNJS_VERSION,function(){Array.prototype.indexOf||(Array.prototype.indexOf=function(n){var u,r,t,i;if(this===null)throw new TypeError;if((u=new Object(this),r=u.length>>>0,r===0)||(t=0,arguments.length>0&&(t=Number(arguments[1]),t!==t?t=0:t!==0&&t!==Infinity&&t!==-Infinity&&(t=(t>0||-1)*Math.floor(Math.abs(t)))),t>=r))return-1;for(i=t>=0?t:Math.max(r-Math.abs(t),0);i<r;i++)if(i in u&&u[i]===n)return i;return-1});Array.prototype.forEach||(Array.prototype.forEach=function(n,t){var u,i,r,f,e;if(this===null)throw new TypeError(" this is null or not defined");if(r=new Object(this),f=r.length>>>0,{}.toString.call(n)!=="[object Function]")throw new TypeError(n+" is not a function");for(t&&(u=t),i=0;i<f;)i in r&&(e=r[i],n.call(u,e,i,r)),i++})}(),i._sliceUserAgent=function(n,t,i){var s=[],r=navigator.userAgent,h=r.indexOf(n),f=r.indexOf(t,h),e,o,u;for(f<0&&(f=r.length),e=r.slice(h,f).split(i),o=e[1].split("."),u=0;u<o.length;++u)s.push(parseInt(o[u],10));return{name:e[0],version:s}},i.getBrowser=function(){var n=navigator.userAgent;return n.indexOf("Chrome")>-1?i._sliceUserAgent("Chrome"," ","/"):n.indexOf("Safari")>-1?i._sliceUserAgent("Safari"," ","/"):n.indexOf("Firefox")>-1?i._sliceUserAgent("Firefox"," ","/"):n.indexOf("MSIE")>-1?i._sliceUserAgent("MSIE",";"," "):null},i.getServerUrl=function(t,i){if(n.location.protocol==="file:")return i?i:"ws://127.0.0.1/ws";var r=n.location.protocol==="https:"?"wss://":"ws://",u=n.location.port!==""?":"+n.location.port:"",f=t?t:"ws";return r+n.location.hostname+u+"/"+f},i.browserNotSupportedMessage="Browser does not support WebSockets (RFC6455)",i.deriveKey=function(n,t){if(t&&t.salt){var i=t.salt,r=t.keylen||32,u=t.iterations||1e4,f=CryptoJS.PBKDF2(n,i,{keySize:r/4,iterations:u,hasher:CryptoJS.algo.SHA256});return f.toString(CryptoJS.enc.Base64)}return n},i._idchars="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789",i._idlen=16,i._subprotocol="wamp",i._newid=function(){for(var n="",t=0;t<i._idlen;t+=1)n+=i._idchars.charAt(Math.floor(Math.random()*i._idchars.length));return n},i._newidFast=function(){return Math.random().toString(36)},i.log=function(){if(arguments.length>1){console.group("Log Item");for(var n=0;n<arguments.length;n+=1)console.log(arguments[n]);console.groupEnd()}else console.log(arguments[0])},i._debugrpc=!1,i._debugpubsub=!1,i._debugws=!1,i._debugconnect=!1,i.debug=function(t,r,u){if("console"in n)i._debugrpc=t,i._debugpubsub=t,i._debugws=r,i._debugconnect=u;else throw"browser does not support console object";},i.version=function(){return i._version},i.PrefixMap=function(){var n=this;n._index={};n._rindex={}},i.PrefixMap.prototype.get=function(n){var t=this;return t._index[n]},i.PrefixMap.prototype.set=function(n,t){var i=this;i._index[n]=t;i._rindex[t]=n},i.PrefixMap.prototype.setDefault=function(n){var t=this;t._index[""]=n;t._rindex[n]=""},i.PrefixMap.prototype.remove=function(n){var t=this,i=t._index[n];i&&(delete t._index[n],delete t._rindex[i])},i.PrefixMap.prototype.resolve=function(n,t){var u=this,i=n.indexOf(":"),r;return i>=0&&(r=n.substring(0,i),u._index[r])?u._index[r]+n.substring(i+1):t===!0?n:null},i.PrefixMap.prototype.shrink=function(n,t){for(var u,r,f=this,i=n.length;i>0;i-=1)if(u=n.substring(0,i),r=f._rindex[u],r)return r+":"+n.substring(i);return t===!0?n:null},i._MESSAGE_TYPEID_WELCOME=0,i._MESSAGE_TYPEID_PREFIX=1,i._MESSAGE_TYPEID_CALL=2,i._MESSAGE_TYPEID_CALL_RESULT=3,i._MESSAGE_TYPEID_CALL_ERROR=4,i._MESSAGE_TYPEID_SUBSCRIBE=5,i._MESSAGE_TYPEID_UNSUBSCRIBE=6,i._MESSAGE_TYPEID_PUBLISH=7,i._MESSAGE_TYPEID_EVENT=8,i.CONNECTION_CLOSED=0,i.CONNECTION_LOST=1,i.CONNECTION_RETRIES_EXCEEDED=2,i.CONNECTION_UNREACHABLE=3,i.CONNECTION_UNSUPPORTED=4,i.CONNECTION_UNREACHABLE_SCHEDULED_RECONNECT=5,i.CONNECTION_LOST_SCHEDULED_RECONNECT=6,i.Deferred=t.defer,i._construct=function(t,i){return"WebSocket"in n?i?new WebSocket(t,i):new WebSocket(t):"MozWebSocket"in n?i?new MozWebSocket(t,i):new MozWebSocket(t):null},i.Session=function(n,t,r,u){var f=this;if(f._wsuri=n,f._options=u,f._websocket_onopen=t,f._websocket_onclose=r,f._websocket=null,f._websocket_connected=!1,f._session_id=null,f._wamp_version=null,f._server=null,f._calls={},f._subscriptions={},f._prefixes=new i.PrefixMap,f._txcnt=0,f._rxcnt=0,f._websocket=f._options&&f._options.skipSubprotocolAnnounce?i._construct(f._wsuri):i._construct(f._wsuri,[i._subprotocol]),!f._websocket){if(r!==undefined){r(i.CONNECTION_UNSUPPORTED);return}throw i.browserNotSupportedMessage;}f._websocket.onmessage=function(n){var t,r,h,e,c,s,v,y,p,w;if(i._debugws&&(f._rxcnt+=1,console.group("WS Receive"),console.info(f._wsuri+"  ["+f._session_id+"]"),console.log(f._rxcnt),console.log(n.data),console.groupEnd()),t=JSON.parse(n.data),t[1]in f._calls){if(t[0]===i._MESSAGE_TYPEID_CALL_RESULT){if(r=f._calls[t[1]],h=t[2],i._debugrpc&&r._ab_callobj!==undefined){for(console.group("WAMP Call",r._ab_callobj[2]),console.timeEnd(r._ab_tid),console.group("Arguments"),e=3;e<r._ab_callobj.length;e+=1)if(c=r._ab_callobj[e],c!==undefined)console.log(c);else break;console.groupEnd();console.group("Result");console.log(h);console.groupEnd();console.groupEnd()}r.resolve(h)}else if(t[0]===i._MESSAGE_TYPEID_CALL_ERROR){var u=f._calls[t[1]],l=t[2],a=t[3],o=t[4];if(i._debugrpc&&u._ab_callobj!==undefined){for(console.group("WAMP Call",u._ab_callobj[2]),console.timeEnd(u._ab_tid),console.group("Arguments"),s=3;s<u._ab_callobj.length;s+=1)if(v=u._ab_callobj[s],v!==undefined)console.log(v);else break;console.groupEnd();console.group("Error");console.log(l);console.log(a);o!==undefined&&console.log(o);console.groupEnd();console.groupEnd()}o!==undefined?u.reject({uri:l,desc:a,detail:o}):u.reject({uri:l,desc:a})}delete f._calls[t[1]]}else if(t[0]===i._MESSAGE_TYPEID_EVENT)y=f._prefixes.resolve(t[1],!0),y in f._subscriptions&&(p=t[1],w=t[2],i._debugpubsub&&(console.group("WAMP Event"),console.info(f._wsuri+"  ["+f._session_id+"]"),console.log(p),console.log(w),console.groupEnd()),f._subscriptions[y].forEach(function(n){n(p,w)}));else if(t[0]===i._MESSAGE_TYPEID_WELCOME)if(f._session_id===null)f._session_id=t[1],f._wamp_version=t[2],f._server=t[3],(i._debugrpc||i._debugpubsub)&&(console.group("WAMP Welcome"),console.info(f._wsuri+"  ["+f._session_id+"]"),console.log(f._wamp_version),console.log(f._server),console.groupEnd()),f._websocket_onopen!==null&&f._websocket_onopen();else throw"protocol error (welcome message received more than once)";};f._websocket.onopen=function(){if(f._websocket.protocol!==i._subprotocol)if(typeof f._websocket.protocol=="undefined")i._debugws&&(console.group("WS Warning"),console.info(f._wsuri),console.log("WebSocket object has no protocol attribute: WAMP subprotocol check skipped!"),console.groupEnd());else if(f._options&&f._options.skipSubprotocolCheck)i._debugws&&(console.group("WS Warning"),console.info(f._wsuri),console.log("Server does not speak WAMP, but subprotocol check disabled by option!"),console.log(f._websocket.protocol),console.groupEnd());else{f._websocket.close(1e3,"server does not speak WAMP");throw"server does not speak WAMP (but '"+f._websocket.protocol+"' !)";}i._debugws&&(console.group("WAMP Connect"),console.info(f._wsuri),console.log(f._websocket.protocol),console.groupEnd());f._websocket_connected=!0};f._websocket.onerror=function(){};f._websocket.onclose=function(n){i._debugws&&(f._websocket_connected?console.log("Autobahn connection to "+f._wsuri+" lost (code "+n.code+", reason '"+n.reason+"', wasClean "+n.wasClean+")."):console.log("Autobahn could not connect to "+f._wsuri+" (code "+n.code+", reason '"+n.reason+"', wasClean "+n.wasClean+")."));f._websocket_onclose!==undefined&&(f._websocket_connected?n.wasClean?f._websocket_onclose(i.CONNECTION_CLOSED,"WS-"+n.code+": "+n.reason):f._websocket_onclose(i.CONNECTION_LOST):f._websocket_onclose(i.CONNECTION_UNREACHABLE));f._websocket_connected=!1;f._wsuri=null;f._websocket_onopen=null;f._websocket_onclose=null;f._websocket=null};f.log=function(){f._options&&"sessionIdent"in f._options?console.group("WAMP Session '"+f._options.sessionIdent+"' ["+f._session_id+"]"):console.group("WAMP Session ["+f._session_id+"]");for(var n=0;n<arguments.length;++n)console.log(arguments[n]);console.groupEnd()}},i.Session.prototype._send=function(t){var r=this,u;if(!r._websocket_connected)throw"Autobahn not connected";switch(!0){case n.Prototype&&typeof top.root.__prototype_deleted=="undefined":case typeof t.toJSON=="function":u=t.toJSON();break;default:u=JSON.stringify(t)}r._websocket.send(u);r._txcnt+=1;i._debugws&&(console.group("WS Send"),console.info(r._wsuri+"  ["+r._session_id+"]"),console.log(r._txcnt),console.log(u),console.groupEnd())},i.Session.prototype.close=function(){var n=this;n._websocket_connected&&n._websocket.close()},i.Session.prototype.sessionid=function(){var n=this;return n._session_id},i.Session.prototype.wsuri=function(){var n=this;return n._wsuri},i.Session.prototype.shrink=function(n,t){var i=this;return t===undefined&&(t=!0),i._prefixes.shrink(n,t)},i.Session.prototype.resolve=function(n,t){var i=this;return t===undefined&&(t=!0),i._prefixes.resolve(n,t)},i.Session.prototype.prefix=function(n,t){var r=this,u;r._prefixes.set(n,t);(i._debugrpc||i._debugpubsub)&&(console.group("WAMP Prefix"),console.info(r._wsuri+"  ["+r._session_id+"]"),console.log(n),console.log(t),console.groupEnd());u=[i._MESSAGE_TYPEID_PREFIX,n,t];r._send(u)},i.Session.prototype.call=function(){for(var t=this,n=new i.Deferred,r,e,u,f;;)if(r=i._newidFast(),!(r in t._calls))break;for(t._calls[r]=n,e=t._prefixes.shrink(arguments[0],!0),u=[i._MESSAGE_TYPEID_CALL,r,e],f=1;f<arguments.length;f+=1)u.push(arguments[f]);return t._send(u),i._debugrpc&&(n._ab_callobj=u,n._ab_tid=t._wsuri+"  ["+t._session_id+"]["+r+"]",console.time(n._ab_tid),console.info()),n.promise.then?n.promise:n},i.Session.prototype.subscribe=function(n,t){var r=this,u=r._prefixes.resolve(n,!0),f,e;if(u in r._subscriptions||(i._debugpubsub&&(console.group("WAMP Subscribe"),console.info(r._wsuri+"  ["+r._session_id+"]"),console.log(n),console.log(t),console.groupEnd()),f=[i._MESSAGE_TYPEID_SUBSCRIBE,n],r._send(f),r._subscriptions[u]=[]),e=r._subscriptions[u].indexOf(t),e===-1)r._subscriptions[u].push(t);else throw"callback "+t+" already subscribed for topic "+u;},i.Session.prototype.unsubscribe=function(n,t){var r=this,u=r._prefixes.resolve(n,!0),f,e,o;if(u in r._subscriptions){if(t!==undefined)if(e=r._subscriptions[u].indexOf(t),e!==-1)f=t,r._subscriptions[u].splice(e,1);else throw"no callback "+t+" subscribed on topic "+u;else f=r._subscriptions[u].slice(),r._subscriptions[u]=[];r._subscriptions[u].length===0&&(delete r._subscriptions[u],i._debugpubsub&&(console.group("WAMP Unsubscribe"),console.info(r._wsuri+"  ["+r._session_id+"]"),console.log(n),console.log(f),console.groupEnd()),o=[i._MESSAGE_TYPEID_UNSUBSCRIBE,n],r._send(o))}else throw"not subscribed to topic "+u;},i.Session.prototype.publish=function(){var o=this,t=arguments[0],r=arguments[1],f=null,n=null,e=null,u=null;if(arguments.length>3){if(!(arguments[2]instanceof Array))throw"invalid argument type(s)";if(!(arguments[3]instanceof Array))throw"invalid argument type(s)";n=arguments[2];e=arguments[3];u=[i._MESSAGE_TYPEID_PUBLISH,t,r,n,e,]}else if(arguments.length>2)if(typeof arguments[2]=="boolean")f=arguments[2],u=[i._MESSAGE_TYPEID_PUBLISH,t,r,f];else if(arguments[2]instanceof Array)n=arguments[2],u=[i._MESSAGE_TYPEID_PUBLISH,t,r,n];else throw"invalid argument type(s)";else u=[i._MESSAGE_TYPEID_PUBLISH,t,r];i._debugpubsub&&(console.group("WAMP Publish"),console.info(o._wsuri+"  ["+o._session_id+"]"),console.log(t),console.log(r),f!==null?console.log(f):n!==null&&(console.log(n),e!==null&&console.log(e)),console.groupEnd());o._send(u)},i.Session.prototype.authreq=function(n,t){return this.call("http://api.wamp.ws/procedure#authreq",n,t)},i.Session.prototype.authsign=function(n,t){return t||(t=""),CryptoJS.HmacSHA256(n,t).toString(CryptoJS.enc.Base64)},i.Session.prototype.auth=function(n){return this.call("http://api.wamp.ws/procedure#auth",n)},i._connect=function(t){var r=new i.Session(t.wsuri,function(){t.connects+=1;t.retryCount=0;t.onConnect(r)},function(r,u){var f=null;switch(r){case i.CONNECTION_CLOSED:t.onHangup(r,"Connection was closed properly ["+u+"]");break;case i.CONNECTION_UNSUPPORTED:t.onHangup(r,"Browser does not support WebSocket.");break;case i.CONNECTION_UNREACHABLE:if(t.retryCount+=1,t.connects===0)t.onHangup(r,"Connection could not be established.");else if(t.retryCount<=t.options.maxRetries)if(f=t.onHangup(i.CONNECTION_UNREACHABLE_SCHEDULED_RECONNECT,"Connection unreachable - scheduled reconnect to occur in "+t.options.retryDelay/1e3+" second(s) - attempt "+t.retryCount+" of "+t.options.maxRetries+".",{delay:t.options.retryDelay,retries:t.retryCount,maxretries:t.options.maxRetries}),f){i._debugconnect&&console.log("Connection unreachable - retrying stopped by app");t.onHangup(i.CONNECTION_RETRIES_EXCEEDED,"Number of connection retries exceeded.")}else i._debugconnect&&console.log("Connection unreachable - retrying ("+t.retryCount+") .."),n.setTimeout(function(){i._connect(t)},t.options.retryDelay);else t.onHangup(i.CONNECTION_RETRIES_EXCEEDED,"Number of connection retries exceeded.");break;case i.CONNECTION_LOST:if(t.retryCount+=1,t.retryCount<=t.options.maxRetries)if(f=t.onHangup(i.CONNECTION_LOST_SCHEDULED_RECONNECT,"Connection lost - scheduled "+t.retryCount+"th reconnect to occur in "+t.options.retryDelay/1e3+" second(s).",{delay:t.options.retryDelay,retries:t.retryCount,maxretries:t.options.maxRetries}),f){i._debugconnect&&console.log("Connection lost - retrying stopped by app");t.onHangup(i.CONNECTION_RETRIES_EXCEEDED,"Connection lost.")}else i._debugconnect&&console.log("Connection lost - retrying ("+t.retryCount+") .."),n.setTimeout(function(){i._connect(t)},t.options.retryDelay);else t.onHangup(i.CONNECTION_RETRIES_EXCEEDED,"Connection lost.");break;default:throw"unhandled close code in ab._connect";}},t.options)},i.connect=function(n,t,r,u){var f={};if(f.wsuri=n,f.options=u?u:{},f.options.retryDelay===undefined&&(f.options.retryDelay=5e3),f.options.maxRetries===undefined&&(f.options.maxRetries=10),f.options.skipSubprotocolCheck===undefined&&(f.options.skipSubprotocolCheck=!1),f.options.skipSubprotocolAnnounce===undefined&&(f.options.skipSubprotocolAnnounce=!1),t)f.onConnect=t;else throw"onConnect handler required!";f.onHangup=r?r:function(n,t,r){i._debugconnect&&console.log(n,t,r)};f.connects=0;f.retryCount=0;i._connect(f)},i.launch=function(n,t,r){i.connect(n.wsuri,function(r){n.appkey&&n.appkey!==""?r.authreq(n.appkey,n.appextra).then(function(u){var f=null,e;typeof n.appsecret=="function"?f=n.appsecret(u):(e=i.deriveKey(n.appsecret,JSON.parse(u).authextra),f=r.authsign(u,e));r.auth(f).then(function(){t?t(r):i._debugconnect&&r.log("Session opened.")},r.log)},r.log):r.authreq().then(function(){r.auth().then(function(){t?t(r):i._debugconnect&&r.log("Session opened.")},r.log)},r.log)},function(n,t,u){r?r(n,t,u):i._debugconnect&&i.log("Session closed.",n,t,u)},n.sessionConfig)},i});ab._UA_FIREFOX=new RegExp(".*Firefox/([0-9+]*).*");ab._UA_CHROME=new RegExp(".*Chrome/([0-9+]*).*");ab._UA_CHROMEFRAME=new RegExp(".*chromeframe/([0-9]*).*");ab._UA_WEBKIT=new RegExp(".*AppleWebKit/([0-9+.]*)w*.*");ab._UA_WEBOS=new RegExp(".*webOS/([0-9+.]*)w*.*");ab._matchRegex=function(n,t){var i=t.exec(n);return i?i[1]:i};ab.lookupWsSupport=function(){var n=navigator.userAgent,t;return n.indexOf("MSIE")>-1?n.indexOf("MSIE 10")>-1?[!0,!0,!0]:n.indexOf("chromeframe")>-1?(t=parseInt(ab._matchRegex(n,ab._UA_CHROMEFRAME)),t>=14)?[!0,!1,!0]:[!1,!1,!1]:n.indexOf("MSIE 8")>-1||n.indexOf("MSIE 9")>-1?[!0,!0,!0]:[!1,!1,!1]:n.indexOf("Firefox")>-1?(t=parseInt(ab._matchRegex(n,ab._UA_FIREFOX)),t)?t>=7?[!0,!1,!0]:t>=3?[!0,!0,!0]:[!1,!1,!0]:[!1,!1,!0]:n.indexOf("Safari")>-1&&n.indexOf("Chrome")==-1?(t=ab._matchRegex(n,ab._UA_WEBKIT),t)?n.indexOf("Windows")>-1&&t=="534+"?[!0,!1,!0]:n.indexOf("Macintosh")>-1&&(t=t.replace("+","").split("."),parseInt(t[0])==535&&parseInt(t[1])>=24||parseInt(t[0])>535)?[!0,!1,!0]:n.indexOf("webOS")>-1?(t=ab._matchRegex(n,ab._UA_WEBOS).split("."),parseInt(t[0])==2)?[!1,!0,!0]:[!1,!1,!1]:[!0,!0,!0]:[!1,!1,!1]:n.indexOf("Chrome")>-1?(t=parseInt(ab._matchRegex(n,ab._UA_CHROME)),t)?t>=14?[!0,!1,!0]:t>=4?[!0,!0,!0]:[!1,!1,!0]:[!1,!1,!1]:n.indexOf("Android")>-1?n.indexOf("Firefox")>-1?[!0,!1,!0]:n.indexOf("CrMo")>-1?[!0,!1,!0]:n.indexOf("Opera")>-1?[!1,!1,!0]:n.indexOf("CrMo")>-1?[!0,!0,!0]:[!1,!1,!1]:n.indexOf("iPhone")>-1||n.indexOf("iPad")>-1||n.indexOf("iPod")>-1?[!1,!1,!0]:[!1,!1,!1]};