# 3DconnexionJS

## 1. DESCRIPTION
---------------
The **3DconnexionJS** framework is 3Dconnexion’s Application Programming Interface (API) for JavaScript applications.

---

## 2. REQUIREMENTS
---------------
The 3DconnexionJS supporting software (Navigation Library and Navigation Proxy executables) require an installation of **3DxWare 10**.

- **3DxWare 10 for macOS:** Version 10.6.1 or newer.
- **3DxWare 10 for Windows:** Version 10.8.12 or newer.

---

## 3. INSTALLATION
---------------
Install 3DconnexionJS using [npm](https://www.npmjs.com/):

```sh
npm install @3dconnexion/3dconnexionjs
```

Make sure you have the required version of 3DxWare 10 installed on your system (see Requirements above).

---

## 4. API DOCUMENTATION
---------------
This package includes a PDF document containing detailed information about the framework's API.

- See [3DconnexionJS.pdf](./3DconnexionJS.pdf) for a comprehensive API reference and usage instructions.

---

## 5. LICENSE
---------------
This package includes the file [LicenseAgreementSDK.txt](./LicenseAgreementSDK.txt) with the license details.

---

## 6. DEPENDENCIES
---------------
This package relies on the following third-party libraries:

- **Crypto-JS** version 4.2.0  
- **Autobahn|JS** version 0.8.2(.1)

> **Note:**  
> The source code for these dependencies is directly included in the package under the `src` directory.  
> These are **not** installed via npm or managed as external packages; they are bundled as part of the framework.

---

## 7. SUPPORT
---------------
For developer support and further resources, visit the [3Dconnexion Software Developer Program](https://3dconnexion.com/software-developer-program/).

_Note: At this time, the project is not hosted publicly on any repository or website._