# Generated by CMake

if(CMAKE_VERSION VERSION_LESS 3.11)
  message(FATAL_ERROR "This file relies on consumers using CMake 3.11 or greater.")
endif()

cmake_policy(PUSH)
cmake_policy(VERSION 2.6)

# Commands may need to know the format version.
set(CMAKE_IMPORT_FILE_VERSION 1)


# Compute the installation prefix relative to this file.
get_filename_component(_IMPORT_PREFIX "${CMAKE_CURRENT_LIST_FILE}" PATH)
if(_IMPORT_PREFIX STREQUAL "/")
  set(_IMPORT_PREFIX "")
endif()

if( CMAKE_SIZEOF_VOID_P EQUAL 8 )
  set(TDxWare_LIBRARIES "${_IMPORT_PREFIX}/lib/x64/TDxNavLib.lib")
else( CMAKE_SIZEOF_VOID_P EQUAL 8 )
  set(TDxWare_LIBRARIES "${_IMPORT_PREFIX}/lib/x86/TDxNavLib.lib")
endif( CMAKE_SIZEOF_VOID_P EQUAL 8 )
set(TDxWare_INCLUDE_DIR "${_IMPORT_PREFIX}/inc")
set(TDxWare_INCLUDE_DIRS ${TDxWare_INCLUDE_DIR})

# ------------------------------------------------------------------------
#  Add imported targets
# ------------------------------------------------------------------------
if(NOT TARGET 3DxWare::headers)
  add_library(3DxWare::headers INTERFACE IMPORTED)
  if(TDxWare_INCLUDE_DIRS)
    set_target_properties(3DxWare::headers PROPERTIES
      INTERFACE_INCLUDE_DIRECTORIES "${TDxWare_INCLUDE_DIRS}")
  endif()
endif()

if(NOT TARGET 3DxWare::Navlib)
  add_library(3DxWare::Navlib STATIC IMPORTED)
  if(TDxWare_INCLUDE_DIRS)
    set_target_properties(3DxWare::Navlib PROPERTIES
                          INTERFACE_INCLUDE_DIRECTORIES "${TDxWare_INCLUDE_DIRS}")
  endif()
  set_target_properties(3DxWare::Navlib PROPERTIES
                        IMPORTED_LINK_INTERFACE_LANGUAGES "CXX"
                        INTERFACE_LINK_LIBRARIES "${TDxWare_LIBRARIES}")
endif()

if(TDxWare_SDK_FIND_COMPONENTS)
  foreach(_comp IN LISTS TDxWare_SDK_FIND_COMPONENTS)
    if("${_comp}" STREQUAL "3DxWare::NlClient")
      if(NOT TARGET 3DxWare::NlClient)
        add_library(3DxWare::NlClient INTERFACE IMPORTED)
        find_package(Boost REQUIRED COMPONENTS coroutine random)
        find_package( OpenSSL REQUIRED )
        find_package( nlohmann_json REQUIRED )

        # include directories
        if(TDxWare_INCLUDE_DIRS)
          list(APPEND _3DxWare_NlClient_INCLUDE_DIRS ${TDxWare_INCLUDE_DIRS})
        endif()
        list(APPEND _3DxWare_NlClient_INCLUDE_DIRS ${OPENSSL_INCLUDE_DIR})
        list(APPEND _3DxWare_NlClient_INCLUDE_DIRS ${Boost_INCLUDE_DIR})
        list(APPEND _3DxWare_NlClient_INCLUDE_DIRS ${nlohmann_json_INCLUDE_DIR})

        # libraries
        list(APPEND _3DxWare_NlClient_TARGET_DEPENDENCIES Boost::random)
        list(APPEND _3DxWare_NlClient_TARGET_DEPENDENCIES Boost::coroutine)
        list(APPEND _3DxWare_NlClient_TARGET_DEPENDENCIES ${OPENSSL_LIBRARIES})

        set_target_properties(3DxWare::NlClient PROPERTIES
                              INTERFACE_INCLUDE_DIRECTORIES "${_3DxWare_NlClient_INCLUDE_DIRS}"
                              INTERFACE_COMPILE_DEFINITIONS WAMP_CLIENT=1)

        # target_link_libraries on imported libraries is supported only since CMake 3.11
        target_link_libraries(3DxWare::NlClient INTERFACE ${_3DxWare_NlClient_TARGET_DEPENDENCIES})

        if (MSVC)
          set_target_properties( 3DxWare::NlClient PROPERTIES
                                 INTERFACE_COMPILE_OPTIONS /bigobj)
        elseif(CMAKE_COMPILER_IS_GNUCXX)
          set_target_properties( 3DxWare::NlClient PROPERTIES
                                 INTERFACE_COMPILE_OPTIONS -Wa,-mbig-obj)
        endif()
      endif()
    endif()
  endforeach()
endif()


# Commands beyond this point should not need to know the version.
set(CMAKE_IMPORT_FILE_VERSION)
cmake_policy(POP)
