// 
// Notice Regarding Standards.  AMD does not provide a license or sublicense to
// any Intellectual Property Rights relating to any standards, including but not
// limited to any audio and/or video codec technologies such as MPEG-2, MPEG-4;
// AVC/H.264; HEVC/H.265; AAC decode/FFMPEG; AAC encode/FFMPEG; VC-1; and MP3
// (collectively, the "Media Technologies"). For clarity, you will pay any
// royalties due for such third party technologies, which may include the Media
// Technologies that are owed as a result of AMD providing the Software to you.
// 
// MIT license 
// 
// Copyright (c) 2016 Advanced Micro Devices, Inc. All rights reserved.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.
//

#ifndef OCLAPPLICATION_H
#define OCLAPPLICATION_H
#pragma once

#include "Interfaces.h"
#include "OGLApplication.h"

#define CL_USE_DEPRECATED_OPENCL_1_2_APIS

#include "../Include/OpenCL/cl_ext.h"

#ifdef _WIN32
    #include "DXApplication.h"
    #include <CL/cl_d3d11.h>
    #include <d3d11.h>
#endif

#include <vector>


#ifdef _WIN32
    #define TAppBase DXApplication
    #define DX11_APP 1
#elif __linux__
    #define TAppBase OGLApplication
    #define OGL_APP 1
#endif


//use GL/DX App for interop
class OCLApplication : 
    public TAppBase
//  public IGraphicsAPI,
//  public IGraphicsAPIFrame,
//  public IGraphicsAPI_P2P
{
public:
    OCLApplication();
    virtual ~OCLApplication();

protected:
    // SSG file specific information
    cl_file_amd     m_clSsgFile;

#ifdef DX11_APP
    // OpenCL D3D11 interop functions
    clCreateFromD3D11BufferKHR_fn       clCreateFromD3D11BufferKHR;
    clEnqueueAcquireD3D11ObjectsKHR_fn  clEnqueueAcquireD3D11ObjectsKHR;
    clEnqueueReleaseD3D11ObjectsKHR_fn  clEnqueueReleaseD3D11ObjectsKHR;
#endif
    bool  InitExtensions();

    // OpenCL SSG functions
    clCreateSsgFileObjectAMD_fn         clCreateSsgFileObjectAMD;
    clGetSsgFileObjectInfoAMD_fn        clGetSsgFileObjectInfoAMD;
    clRetainSsgFileObjectAMD_fn         clRetainSsgFileObjectAMD;
    clReleaseSsgFileObjectAMD_fn        clReleaseSsgFileObjectAMD;
    clEnqueueReadSsgFileAMD_fn          clEnqueueReadSsgFileAMD;
    clEnqueueWriteSsgFileAMD_fn         clEnqueueWriteSsgFileAMD;
    bool  InitSsgExtensions();


    // buffers
    std::vector<cl_mem>  m_iopBuffers;
    std::vector<cl_mem>  m_clBuffers;
    bool  InitBuffers(long long dataBufferSize);


    // OpenCL specific information
    cl_context  m_clContext;

    cl_platform_id  m_clPlatformId;
    bool  FindPlatformID();

    std::vector<cl_command_queue>  m_clCommandQueueA;
    std::vector<cl_command_queue>  m_clCommandQueueB;
    std::vector<cl_event>          m_clEventA;
    std::vector<cl_event>          m_clEventB;
    bool  InitCommandQueue();


public:
    // IGraphicsAPI
    bool Init(IApplication *pAppliation, int argc, char ** argv);
    void Term();

//	void Run();
//	void Pause(bool pause);
	void Stop();
//  void SetFullScreen(bool fullScreen);

    // IGraphicsAPIFrame
//  void BeginFrame(bool clear);
    void DrawFrame();
//  void DrawStatus(char * text);
//  void DrawSeekbar(int frameNumber, int totalNumberOfFrames);
//  void EndFrame();

    // IGraphicsAPI_P2P
    bool P2PIsExtensionActive();
    bool P2POpenFile(const char * filename);
    unsigned long long P2PGetFileSize();
    unsigned long long P2PGetSectorSize();
    bool P2PReadFile(unsigned long long fileOffset, unsigned long long size);
    void P2PCloseFile();
//  bool IsFirstFrame() { return false; }
};

#endif    /* OCLAPPLICATION_H */

