// 
// Notice Regarding Standards.  AMD does not provide a license or sublicense to
// any Intellectual Property Rights relating to any standards, including but not
// limited to any audio and/or video codec technologies such as MPEG-2, MPEG-4;
// AVC/H.264; HEVC/H.265; AAC decode/FFMPEG; AAC encode/FFMPEG; VC-1; and MP3
// (collectively, the "Media Technologies"). For clarity, you will pay any
// royalties due for such third party technologies, which may include the Media
// Technologies that are owed as a result of AMD providing the Software to you.
// 
// MIT license 
// 
// Copyright (c) 2016 Advanced Micro Devices, Inc. All rights reserved.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.
//

#ifndef _SETTINGS_H
#define _SETTINGS_H
#pragma once

#define MAX_NUM_FILESTREAMS 10
#define MAX_FILENAME_LEN 240

#include "Interfaces.h"

class Settings : public ISettings
{
public:
    Settings();

    bool Parse(int argc, char** argv);

private:
    // attributes
    VIDEO_FORMAT   m_Format;
    API_EXTENSION  m_ApiExt;
    
    int     m_Width;
    int     m_Height;
    int     m_FrameRate;
    int64_t m_frameOffset;  // in case the frame has some header information we want to skip...
    int     m_NumBuffers;
    int     m_NumThreads;
    int     m_Loop;
    bool    m_Sync;
    bool    m_VSync;

    int     m_NumFileStreams;
    char    m_Files[MAX_NUM_FILESTREAMS][MAX_FILENAME_LEN];

// ISettings
public:
    API_EXTENSION  ApiExt() const  { return m_ApiExt; }
    VIDEO_FORMAT   Format() const  { return m_Format; }

    int  Width() const             { return m_Width; }
    int  Height() const            { return m_Height; }
    int  FrameRate() const         { return m_FrameRate; }

    int64_t  FrameOffset() const   { return m_frameOffset; }
    int64_t  FrameSize() const;

    int  NumBuffers() const        { return m_NumBuffers; }
    int  NumThreads() const        { return m_NumThreads; }
    int  Loop() const              { return m_Loop; }

    bool Sync() const              { return m_Sync; }
    bool VSync() const             { return m_VSync; }

    int  NumFileStreams() const    { return m_NumFileStreams; }
    const char * Filename(int index) const { return m_Files[index]; }
};

#endif
