// 
// Notice Regarding Standards.  AMD does not provide a license or sublicense to
// any Intellectual Property Rights relating to any standards, including but not
// limited to any audio and/or video codec technologies such as MPEG-2, MPEG-4;
// AVC/H.264; HEVC/H.265; AAC decode/FFMPEG; AAC encode/FFMPEG; VC-1; and MP3
// (collectively, the "Media Technologies"). For clarity, you will pay any
// royalties due for such third party technologies, which may include the Media
// Technologies that are owed as a result of AMD providing the Software to you.
// 
// MIT license 
// 
// Copyright (c) 2016 Advanced Micro Devices, Inc. All rights reserved.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.
//

#ifndef _INTERFACES_H
#define _INTERFACES_H
#pragma once

#include <stdint.h>

enum VIDEO_FORMAT
{
    FORMAT_RGB101010,
    FORMAT_YUV420_8 // 8-bit
};

enum API_EXTENSION
{
    API_EXT_DX,
    API_EXT_OPENGL,
    API_EXT_OPENCL
};

enum KEY_CODES
{
    KEY_ESCAPE,
    KEY_SPACE,
    KEY_FULLSCREEN,
    KEY_FPSCONTROL
};

class ISettings
{
public:
    virtual API_EXTENSION ApiExt() const = 0;
    virtual VIDEO_FORMAT Format() const = 0;
    virtual int Width() const = 0;
    virtual int Height() const = 0;
    virtual int FrameRate() const = 0;
    virtual int64_t  FrameSize() const = 0;
    virtual int64_t  FrameOffset() const = 0;
    virtual int NumBuffers() const = 0;
    virtual int NumThreads() const = 0;
    virtual int Loop() const = 0;
    virtual bool Sync() const = 0;
    virtual bool VSync() const = 0;
    virtual int NumFileStreams() const = 0;
    virtual const char * Filename(int index) const = 0;
};

class IApplication
{
public:
    virtual ISettings * GetSettings() = 0;
    virtual bool HandleFrame() = 0;
    virtual void HandleKey(int keyCode) = 0;
    virtual void HandleMouseDown(int x, int y) = 0;
    virtual void HandleMouseMove(int x, int y) = 0;
    virtual void HandleMouseUp(int x, int y) = 0;
};

class IGraphicsEngine
{
public:
    IGraphicsEngine()           {};
    virtual ~IGraphicsEngine()  {};
};

class IGraphicsAPI
{
public:
    virtual bool Init(IApplication *pApplication, int argc, char ** argv) = 0;
    virtual void Term() = 0;

    virtual void Run() = 0;
    virtual void Pause(bool pause) = 0;
    virtual void Stop() = 0;
    virtual void SetFullScreen(bool fullScreen) = 0;
};

class IGraphicsAPIFrame
{
public:
    virtual void BeginFrame(bool clear) = 0;
    virtual void DrawFrame() = 0;
    virtual void DrawStatus(char * text) = 0;
    virtual void DrawSeekbar(int frameNumber, int totalNumberOfFrames) = 0;
    virtual void EndFrame() = 0;
};

class IGraphicsAPI_P2P
{
public:
    virtual bool P2PIsExtensionActive() = 0;
    virtual bool P2POpenFile(const char * filename) = 0;
    virtual unsigned long long P2PGetFileSize() = 0;
    virtual unsigned long long P2PGetSectorSize() = 0;
    virtual bool P2PReadFile(unsigned long long fileOffset, unsigned long long size) = 0;
    virtual void P2PCloseFile() = 0;
    virtual bool IsFirstFrame() = 0;
};

#endif