// 
// Notice Regarding Standards.  AMD does not provide a license or sublicense to
// any Intellectual Property Rights relating to any standards, including but not
// limited to any audio and/or video codec technologies such as MPEG-2, MPEG-4;
// AVC/H.264; HEVC/H.265; AAC decode/FFMPEG; AAC encode/FFMPEG; VC-1; and MP3
// (collectively, the "Media Technologies"). For clarity, you will pay any
// royalties due for such third party technologies, which may include the Media
// Technologies that are owed as a result of AMD providing the Software to you.
// 
// MIT license 
// 
// Copyright (c) 2016 Advanced Micro Devices, Inc. All rights reserved.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.
//

#ifndef _APPLICATION_H
#define _APPLICATION_H
#pragma once

#include "Interfaces.h"
#include "Settings.h"
#include "Timer.h"

#include <stdio.h>


class Application : public IApplication
{
public:
    Application(ISettings * pSettings);
    virtual ~Application();

    void SetEngine(IGraphicsEngine* pEngine);
    bool Init(int argc, char ** argv);
    void Run();
    void Term();

// IApplication
public:
    ISettings * GetSettings() { return m_Settings; }
    bool HandleFrame();
    void HandleKey(int keyCode);
    void HandleMouseDown(int x, int y);
    void HandleMouseMove(int x, int y);
    void HandleMouseUp(int x, int y);

private:
    void Clear();

    ISettings * m_Settings;

    unsigned long long  m_FileSize;

    IGraphicsAPI*       m_API;
    IGraphicsAPIFrame*  m_pAPIFrame;
    IGraphicsAPI_P2P*   m_pAPI_P2P;

    unsigned long long  m_FrameSize;

    // state
    int m_FrameCounter;
    unsigned long long m_DataOffset;
    bool m_FullScreen;
    bool m_Paused;
    int m_LoopCounter;
    bool m_FPSOverride;
    

    bool m_MouseDown;

    bool IsSeekBar(int x, int y);
    void Seek(int x, int y);

    // statistics
    int m_FPS;
    int m_ReadSpeed;
    float m_AvgReadSpeed;
    Timer m_StatsTimer;
    Timer m_FrameTimer;
    unsigned long long m_LocalFrameCounter;
    unsigned long long m_TotalDataSize;

    void  CalculateStats();
    void  GenerateFpsText(char* pTxt);
};

#endif