// 
// Notice Regarding Standards.  AMD does not provide a license or sublicense to
// any Intellectual Property Rights relating to any standards, including but not
// limited to any audio and/or video codec technologies such as MPEG-2, MPEG-4;
// AVC/H.264; HEVC/H.265; AAC decode/FFMPEG; AAC encode/FFMPEG; VC-1; and MP3
// (collectively, the "Media Technologies"). For clarity, you will pay any
// royalties due for such third party technologies, which may include the Media
// Technologies that are owed as a result of AMD providing the Software to you.
// 
// MIT license 
// 
// Copyright (c) 2016 Advanced Micro Devices, Inc. All rights reserved.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.
//

#ifndef _AMDDXEXTSSGAPI_H_
#define _AMDDXEXTSSGAPI_H_
#pragma once

/**
***************************************************************************************************
* @file  AmdDxExtSSGApi.h
* @brief AMD SSG Extension API include file
***************************************************************************************************
*/

#include <d3d11.h>

#include "AmdDxExtApi.h"
#include "AmdDxExtIface.h"
#include "AmdDxExtSSG.h"

const unsigned int AmdDxSSGMajorVersion = 1;
const unsigned int AmdDxSSGMinorVersion = 0;

// Extended SSG extension ID passed to IAmdDxExt::GetExtInterface()
const unsigned int AmdDxExtSsgID = 22;

/**
***************************************************************************************************
* @brief Abstract extended SSG interface class
*
***************************************************************************************************
*/
class IAmdDxExtSSG : public IAmdDxExtInterface
{
public:
    // Version information
    virtual HRESULT GetExtensionVersion(AmdDxSsgVersion* pVersion) = 0;

    // Open or create a file and get a SSG file handle for it
    // The handle will be used later in data transfer calls
    virtual HRESULT CreateFile(const WCHAR* pFileName, AmdDxSsgFileAccess fileAccess,
                               AmdDxSsgFileHandle* phFile) = 0;

    // Release a file when it is no longer used
    virtual HRESULT ReleaseFile(AmdDxSsgFileHandle hFile) = 0;

    // Get size information of a file
    // File transfer in SSG EXT requires that transfer size & offset be aligned to block
    // boundary
    virtual HRESULT GetFileInfo(AmdDxSsgFileHandle hFile, AmdDxSsgFileInfo* pInfo) = 0;

    // Create an event to use in asynchronous file transfer
    virtual HRESULT CreateEvent(AmdDxSsgEventHandle* phEvent) = 0;

    // Delete an event
    virtual HRESULT DestroyEvent(AmdDxSsgEventHandle hEvent) = 0;

    // Wait for an asynchronous file transfer to complete
    // The event handle should have been submitted in a previous transfer call
    virtual HRESULT WaitEvent(AmdDxSsgEventHandle hEvent) = 0;

    // P2P transfer file data to a D3D11 buffer
    virtual HRESULT ReadBufferFromFile(ID3D11Buffer* pBuffer, AmdDxSsgFileHandle hFile, UINT numRegions,
                                       AmdDxSsgRegionDesc* pRegions, AmdDxSsgEventHandle hEvent) = 0;

    // P2P transfer D3D11 buffer data to a file
    virtual HRESULT WriteBufferToFile(ID3D11Buffer* pBuffer, AmdDxSsgFileHandle hFile, UINT numRegions,
                                      AmdDxSsgRegionDesc* pRegions, AmdDxSsgEventHandle hEvent) = 0;

};

#endif // _AMDDXEXTSSGAPI_H_

