#version 330 core
layout (location = 0) in vec3 aPos;
layout (location = 1) in vec3 aNormal;
layout (location = 2) in vec2 aTexCoords;

out vec2 TexCoords;
out vec3 FragWorldPos;

uniform mat4 model;
uniform mat4 view;
uniform mat4 projection;

void main()
{ 
    TexCoords = aTexCoords;    
    vec4 wp = model * vec4(aPos, 1.0);
    gl_Position = projection * view * wp;
    FragWorldPos = wp.xyz;
}