#pragma once

#include <vector>
#include <string>
#include "model_loader.h"

namespace Engine {

    struct SceneSettings {
        float separation = 0.65f;
        float convergence = 100.0f;
        float nearPlane = 0.1f;
        float farPlane = 200.0f;
        int msaaSamples = 2;
        bool radarEnabled = false;
        glm::vec2 radarPos = glm::vec2(0);
        bool radarShowScene = true;
        float radarScale = 0.3f;
    };

    struct Scene {
        std::vector<Model> models;
        std::vector<PointCloud> pointClouds;
        SceneSettings settings;
    };

    void saveScene(const std::string& filename, const Scene& scene);
    void saveModelData(const Model& model, const std::string& filename);
    Scene loadScene(const std::string& filename);
    void loadModelData(Model& model, const std::string& filename);

}  // namespace Engine