// cmdStereoView.cpp : command file
//

#include "StdAfx.h"
#include "StereoViewPlugIn.h"

IMPLEMENT_DYNCREATE(CRhStereoOptions, CRhinoTabbedDockBarDialog);


////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////
//
// BEGIN StereoView command
//
/////////////////////////////////////////////////////////////////////////////
//
CStereoRenderConduit::CStereoRenderConduit() 
  : CRhinoDisplayConduit(CSupportChannels::SC_SETUPFRUSTUM)
{
  EnableConstantBinding(false);
}

/////////////////////////////////////////////////////////////////////////////
//
CStereoRenderConduit::~CStereoRenderConduit()
{
}

/////////////////////////////////////////////////////////////////////////////
//
void CStereoRenderConduit::CalcFrustumOffsets(double       Parallax, double  Serparation,
                                              ON_3dVector& cam,      double& asym)
{
  double                va;
  const CRhinoViewport* pVP = Viewport();

  if(pVP == nullptr)
    return;

  const ON_Viewport&    vp = pVP->VP();
  const ON_3dPoint&     Location = vp.CameraLocation();

  vp.GetCameraAngle(&va);

  double    screen_scale = 0.075; // fudge factor to prevent exact axis alignment...
  double    target_dist  = (Location - vp.TargetPoint())*vp.CameraZ();
  double    dX           = target_dist * 2.0 * tan(va);
  double    CameraOffset = dX * Serparation / 2.0 * screen_scale;
  double    n_over_d     = vp_frustum_near / target_dist;

  asym = CameraOffset * Parallax * n_over_d;

  ON_3dVector   dOffset = ON_CrossProduct(vp.CameraDirection(), vp.CameraUp());

  dOffset.Unitize();
  cam = CameraOffset * dOffset;
}

/////////////////////////////////////////////////////////////////////////////
//
void CStereoRenderConduit::CaptureFrustumParams(CRhinoDisplayPipeline& pipeline)
{
  const ON_Viewport& vp = pipeline.VP();

  vp_camera_location = vp.CameraLocation();
  vp_camera_up = vp.CameraUp();
  vp_camera_dir = vp.CameraDirection();
  vp.GetFrustum(&vp_frustum_left, &vp_frustum_right,
                &vp_frustum_bottom, &vp_frustum_top,
                &vp_frustum_near, &vp_frustum_far);
}

/////////////////////////////////////////////////////////////////////////////
//
bool CStereoRenderConduit::ExecConduit(CRhinoDisplayPipeline& dp,
                                       UINT                   channel,
                                       bool&                  terminate)
{
  double       asymetry    = 0.0;
  double       dParallax   = m_Settings.m_nParallax / 10.0;   // UI is setup to allow min/max -50/50 steps. Map result to -5..5
  double       dSeparation = m_Settings.m_nSeparation / 10.0;
  int          eye = dp.ActiveStereoProjection();
  ON_3dVector  cam;
  ON_Viewport& vp = dp.VP();
  
  if (dp.IsPrinting())
    return true;

  vp.SetFrustumLeftRightSymmetry(false);

  CaptureFrustumParams(dp);
  CalcFrustumOffsets(dParallax, dSeparation, cam, asymetry);
  if (eye == 0)
  {
    vp.SetCameraLocation(vp_camera_location - cam);
  }
  else
  {
    vp.SetCameraLocation(vp_camera_location + cam);
    asymetry = -asymetry;
  }

  m_pChannelAttrs->m_dLeft  = vp_frustum_left  + asymetry;
  m_pChannelAttrs->m_dRight = vp_frustum_right + asymetry;

  return true;
}

