#include "stdafx.h"
#include "StereoViewApp.h"
#include "resource.h"

BEGIN_MESSAGE_MAP(CRhStereoOptions, CRhinoTabbedDockBarDialog)
  ON_LBN_SELCHANGE(IDC_LIST_VIEWS, OnListViewSelChange)
  ON_CLBN_CHKCHANGE(IDC_LIST_VIEWS, OnListViewCheckChange)
  ON_WM_SIZE()
  ON_WM_HSCROLL()
END_MESSAGE_MAP()

CRhStereoOptions::CRhStereoOptions()
{
}


CRhStereoOptions::~CRhStereoOptions()
{
}

/////////////////////////////////////////////////////////////////////////////
//
ON_UUID CRhStereoOptions::ID()
{
  // {E8A0E1D1-C998-479F-95F4-3E54CDEB2F1B}
  static const GUID uuid =
  { 0xe8a0e1d1, 0xc998, 0x479f,{ 0x95, 0xf4, 0x3e, 0x54, 0xcd, 0xeb, 0x2f, 0x1b } };
  return uuid;
}

/////////////////////////////////////////////////////////////////////////////
//
ON_UUID CRhStereoOptions::TabId() const
{
  return CRhStereoOptions::ID();
}

/////////////////////////////////////////////////////////////////////////////
//
const wchar_t* CRhStereoOptions::Caption(void) const
{
  return L"Stereo 3D View";
}

/////////////////////////////////////////////////////////////////////////////
//
ON_UUID CRhStereoOptions::PlugInId(void) const
{
  return ON_nil_uuid;
}

/////////////////////////////////////////////////////////////////////////////
//
void CRhStereoOptions::DoDataExchange(CDataExchange* pDX)
{
  __super::DoDataExchange(pDX);
  //{{AFX_DATA_MAP(CRhStereoOptions)
  DDX_Control(pDX, IDC_LIST_VIEWS, m_views);
  DDX_Control(pDX, IDC_PARALLAX, m_Parallax);
  DDX_Control(pDX, IDC_SEPARATION, m_Separation);
  //}}AFX_DATA_MAP

  ON_wString   sVal;

  CWnd*  pCtrl = GetDlgItem(IDC_ST_PARALLAXVALUE);
  if (pCtrl != nullptr)
  {
    sVal.Format(L"%0.2f", (double)m_Parallax.GetPos() / 10.0);
    pCtrl->SetWindowTextW(sVal);
  }
  pCtrl = GetDlgItem(IDC_ST_SEPARATIONVALUE);
  if (pCtrl != nullptr)
  {
    sVal.Format(L"%0.2f", (double)m_Separation.GetPos() / 10.0);
    pCtrl->SetWindowTextW(sVal);
  }
}

void CRhStereoOptions::AddCheckBoxHelper(const wchar_t* str, const ON_UUID& viewport_id)
{
  int listIndex = m_views.AddString(str);
  m_views.SetCheck(listIndex, ::StereoApp().IsStereoEnabled(viewport_id)?1:0);
  m_viewIds.Append(viewport_id);
}

void CRhStereoOptions::BuildViewList(CRhinoView* pSkipView)
{
  //int curSel = m_views.GetCurSel();
  m_views.ResetContent();
  m_viewIds.SetCount(0);

  //m_viewscontrol_state.Empty();
  //if( m_cliplist.Count() == 0 )
  //BuildClipList();
  CRhinoDoc* pDoc = RhinoApp().ActiveDoc();
  if (NULL == pDoc)
    return;

  // build list of model views
  CRhinoModelViewIterator view_it(pDoc->RuntimeSerialNumber());
  for (CRhinoView* pView = view_it.First(); 0 != pView; pView = view_it.Next())
  {
    if (pView == pSkipView)
      continue;
    ON_wString name = pView->MainViewport().Name();
    ON_UUID viewport_id = pView->MainViewport().ViewportId();
    AddCheckBoxHelper(name.Array(), viewport_id);
  }
}


BOOL CRhStereoOptions::OnInitDialog()
{
  CRhinoTabbedDockBarDialog::OnInitDialog();
  m_Resize.Add(IDC_ST_ABT_FRAME, CRhinoUiDialogItemResizer::resize_lockwidth);
  m_Resize.Add(IDC_ST_CRFRAME, CRhinoUiDialogItemResizer::resize_lockwidth);
  m_Resize.Add(IDC_LIST_VIEWS, CRhinoUiDialogItemResizer::resize_lockwidth);
  m_Resize.Add(IDC_PARALLAX, CRhinoUiDialogItemResizer::resize_lockwidth);
  m_Resize.Add(IDC_SEPARATION, CRhinoUiDialogItemResizer::resize_lockwidth);
  m_Resize.Add(IDC_ST_DIVERGE, CRhinoUiDialogItemResizer::resize_lockright);

  m_views.SetCheckStyle(BS_AUTOCHECKBOX);
  BuildViewList();

  CRhinoEventWatcher::Register();
  CRhinoEventWatcher::Enable(true);

  CStereoSettings   ss = ::StereoApp().StereoSettings();

  m_Parallax.SetRange(-50, 50);
  m_Parallax.SetPos(ss.m_nParallax);
  m_Separation.SetRange(-50, 50);
  m_Separation.SetPos(ss.m_nSeparation);

  UpdateData(false);

  return TRUE;
}

/////////////////////////////////////////////////////////////////////////////
//
void CRhStereoOptions::OnSize(UINT nType, int cx, int cy)
{
  CRhinoTabbedDockBarDialog::OnSize(nType, cx, cy);
}

void CRhStereoOptions::OnCreateView(CRhinoView* rhino_view)
{
  if (NULL == rhino_view)
    return;
  BuildViewList();
}

void CRhStereoOptions::OnDestroyView(CRhinoView* rhino_view)
{
  if (NULL == rhino_view)
    return;
  BuildViewList(rhino_view);
}

void CRhStereoOptions::OnRenameView(CRhinoView* rhino_view)
{
  if (NULL == rhino_view)
    return;
  BuildViewList();
}

void CRhStereoOptions::OnSetActiveView(CRhinoView* rhino_view)
{
  UUID id = rhino_view->MainViewport().ViewportId();
  int index = m_viewIds.Search(&id, ON_UuidList::CompareUuid);
  if (index >= 0)
    m_views.SetCurSel(index);
}

void CRhStereoOptions::OnListViewSelChange()
{
  int sel = m_views.GetCurSel();
  if ((sel >= 0) && (sel < m_viewIds.Count()))
  {
    ::RhinoApp().SetActiveViewport(m_viewIds[sel]);
  }
}

void CRhStereoOptions::OnListViewCheckChange()
{
  int sel = m_views.GetCurSel();
  int state = m_views.GetCheck(sel);

  ::StereoApp().EnableStereo(m_viewIds[sel], state);
}

void CRhStereoOptions::OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar)
{
  CStereoSettings  ss = ::StereoApp().StereoSettings();

  UpdateData();
  if (pScrollBar->m_hWnd == m_Parallax.m_hWnd)
  {
    nPos = m_Parallax.GetPos();
    ss.m_nParallax = nPos;
  }
  else if (pScrollBar->m_hWnd == m_Separation.m_hWnd)
  {
    nPos = m_Separation.GetPos();
    ss.m_nSeparation = nPos;
  }
  ::StereoApp().SetStereoSettings(ss);
}
