﻿// StereoViewPlugIn.cpp : defines the initialization routines for the plug-in.
//

#include "StdAfx.h"
#include "rhinoSdkPlugInDeclare.h"
#include "StereoViewPlugIn.h"
#include "Resource.h"

// The plug-in object must be constructed before any plug-in classes derived
// from CRhinoCommand. The #pragma init_seg(lib) ensures that this happens.
#pragma warning(push)
#pragma warning(disable : 4073)
#pragma init_seg(lib)
#pragma warning(pop)

// Rhino plug-in declaration
RHINO_PLUG_IN_DECLARE

// Rhino plug-in name
// Provide a short, friendly name for this plug-in.
RHINO_PLUG_IN_NAME(L"Stereo3DView");

// Rhino plug-in id
// Provide a unique uuid for this plug-in.
RHINO_PLUG_IN_ID(L"DAA1C67E-36DE-44D1-81E5-2C33EF3E4650");

// Rhino plug-in version
// Provide a version number string for this plug-in.
RHINO_PLUG_IN_VERSION(__DATE__ "  " __TIME__)

// Rhino plug-in description
// Provide a description of this plug-in.
RHINO_PLUG_IN_DESCRIPTION(L"Stereo3DView plug-in for Rhinoceros®");

// Rhino plug-in icon resource id
// Provide an icon resource this plug-in.
// Icon resource should contain 16, 24, 32, 48, and 256-pixel image sizes.
RHINO_PLUG_IN_ICON_RESOURCE_ID(IDI_ICON);

// Rhino plug-in developer declarations
// TODO: fill in the following developer declarations with
// your company information. Note, all of these declarations
// must be present or your plug-in will not load.
//
// When completed, delete the following #error directive.
RHINO_PLUG_IN_DEVELOPER_ORGANIZATION(L"Robert McNeel & Associates");
RHINO_PLUG_IN_DEVELOPER_ADDRESS(L"3670 Woodland Park Avenue North\015\012Seattle WA 98103");
RHINO_PLUG_IN_DEVELOPER_COUNTRY(L"United States");
RHINO_PLUG_IN_DEVELOPER_PHONE(L"206-545-6877");
RHINO_PLUG_IN_DEVELOPER_FAX(L"206-545-7321");
RHINO_PLUG_IN_DEVELOPER_EMAIL(L"jeff@mcneel.com");
RHINO_PLUG_IN_DEVELOPER_WEBSITE(L"http://www.rhino3d.com");
RHINO_PLUG_IN_UPDATE_URL(L"http://www.rhino3d.com/support");

// The one and only CStereoViewPlugIn object
static class CStereoViewPlugIn thePlugIn;

/////////////////////////////////////////////////////////////////////////////
// CStereoViewPlugIn definition

CStereoViewPlugIn& StereoViewPlugIn()
{
  // Return a reference to the one and only CStereoViewPlugIn object
  return thePlugIn;
}

CStereoViewPlugIn::CStereoViewPlugIn()
{
  // Description:
  //   CStereoViewPlugIn constructor. The constructor is called when the
  //   plug-in is loaded and "thePlugIn" is constructed. Once the plug-in
  //   is loaded, CStereoViewPlugIn::OnLoadPlugIn() is called. The
  //   constructor should be simple and solid. Do anything that might fail in
  //   CStereoViewPlugIn::OnLoadPlugIn().

  // TODO: Add construction code here
  m_plugin_version = RhinoPlugInVersion();
}

/////////////////////////////////////////////////////////////////////////////
// Required overrides

const wchar_t* CStereoViewPlugIn::PlugInName() const
{
  // Description:
  //   Plug-in name display string.  This name is displayed by Rhino when
  //   loading the plug-in, in the plug-in help menu, and in the Rhino
  //   interface for managing plug-ins.

  // TODO: Return a short, friendly name for the plug-in.
  return RhinoPlugInName();
}

const wchar_t* CStereoViewPlugIn::PlugInVersion() const
{
  // Description:
  //   Plug-in version display string. This name is displayed by Rhino
  //   when loading the plug-in and in the Rhino interface for managing
  //   plug-ins.

  // TODO: Return the version number of the plug-in.
  return m_plugin_version;
}

GUID CStereoViewPlugIn::PlugInID() const
{
  // Description:
  //   Plug-in unique identifier. The identifier is used by Rhino to
  //   manage the plug-ins.

  // TODO: Return a unique identifier for the plug-in.
  // {288B9BB8-CACB-402D-B558-7C840DEC3A0F}
  return ON_UuidFromString(RhinoPlugInId());
}

/////////////////////////////////////////////////////////////////////////////
// Additional overrides

BOOL CStereoViewPlugIn::OnLoadPlugIn()
{
  CRhinoTabbedDockBarDialog::Register(RUNTIME_CLASS(CRhStereoOptions), IDD_STEREO_OPTIONS, IDI_ICON, AfxGetStaticModuleState());
  return TRUE;
}

/////////////////////////////////////////////////////////////////////////////
void CStereoViewPlugIn::OnUnloadPlugIn()
{
  // Description:
  //    Called one time when plug-in is about to be unloaded. By this time,
  //    Rhino's mainframe window has been destroyed, and some of the SDK
  //    managers have been deleted. There is also no active document or active
  //    view at this time. Thus, you should only be manipulating your own objects.
  //    or tools here.

  // TODO: Add plug-in cleanup code here.
}

/////////////////////////////////////////////////////////////////////////////
void CStereoViewPlugIn::LoadProfile(LPCTSTR lpszSection, CRhinoProfileContext & pc)
{
  CStereoSettings  ss = ::StereoApp().StereoSettings();

  int  nVal;

  if (pc.LoadProfileInt(lpszSection, L"Stereo Parallax", &nVal))
    ss.m_nParallax = nVal;

  if (pc.LoadProfileInt(lpszSection, L"Stereo Separation", &nVal))
    ss.m_nSeparation = nVal;

  ::StereoApp().SetStereoSettings(ss);
}

/////////////////////////////////////////////////////////////////////////////
void CStereoViewPlugIn::SaveProfile(LPCTSTR lpszSection, CRhinoProfileContext & pc)
{
  CStereoSettings  ss = ::StereoApp().StereoSettings();

  pc.SaveProfileInt(lpszSection, L"Stereo Parallax", ss.m_nParallax);
  pc.SaveProfileInt(lpszSection, L"Stereo Separation", ss.m_nSeparation);
}

