// StereoView.h : main header file for the StereoView DLL.
//

#pragma once

#ifndef __AFXWIN_H__
	#error "include 'stdafx.h' before including this file for PCH"
#endif

#include "resource.h" // main symbols

/////////////////////////////////////////////////////////////////////////////
class CStereoSettings
{
public:
  CStereoSettings() = default;

  int   m_nParallax   = 15;  // converted to a %
  int   m_nSeparation = 10;  // converted to a %
};

/////////////////////////////////////////////////////////////////////////////
class CStereoRenderConduit : public CRhinoDisplayConduit
{
public:
   CStereoRenderConduit();
  ~CStereoRenderConduit();

  CStereoSettings  GetSettings(void) { return m_Settings; }
  void             SetSettings(const CStereoSettings& settings) { m_Settings = settings; }

protected:
  bool ExecConduit(CRhinoDisplayPipeline& pipeline,
                   UINT channel,
                   bool& terminate) override;

  void CaptureFrustumParams(CRhinoDisplayPipeline& pipeline);

private:
  CStereoSettings m_Settings;

  double  vp_frustum_left   = 0.0;
  double  vp_frustum_right  = 0.0;
  double  vp_frustum_bottom = 0.0;
  double  vp_frustum_top    = 0.0;
  double  vp_frustum_near   = 0.0;
  double  vp_frustum_far    = 0.0;

  ON_3dPoint  vp_camera_location;
  ON_3dVector vp_camera_up;
  ON_3dVector vp_camera_dir;

  void  CalcFrustumOffsets(double Parallax, double Serparation, ON_3dVector& cam, double& asym);
};


/////////////////////////////////////////////////////////////////////////////
class CStereoViewApp : public CWinApp
{
public:
  // CRITICAL: DO NOT CALL RHINO SDK FUNCTIONS HERE!
  // Only standard MFC DLL instance construction belongs here. 
  // All other significant initialization should take place in
  // CStereoViewPlugIn::OnLoadPlugIn().
	CStereoViewApp() = default;

  // CRITICAL: DO NOT CALL RHINO SDK FUNCTIONS HERE!
  // Only standard MFC DLL instance initialization belongs here. 
  // All other significant initialization should take place in
  // CStereoViewPlugIn::OnLoadPlugIn().
	BOOL InitInstance() override;
  
  // CRITICAL: DO NOT CALL RHINO SDK FUNCTIONS HERE!
  // Only standard MFC DLL instance clean up belongs here. 
  // All other significant cleanup should take place in either
  // CStereoViewPlugIn::OnSaveAllSettings() or
  // CStereoViewPlugIn::OnUnloadPlugIn().  
	int ExitInstance() override;
  
	DECLARE_MESSAGE_MAP()

public:
  CStereoSettings  StereoSettings(void);
  void             SetStereoSettings(const CStereoSettings& settings);
  void             EnableStereo(const ON_UUID& ViewId, int state);
  bool             IsStereoEnabled(const ON_UUID& ViewId);

private:
  CStereoRenderConduit  m_Conduit;

};

CStereoViewApp& StereoApp(void);