// StereoView.cpp : Defines the initialization routines for the DLL.
//

#include "stdafx.h"
#include "StereoViewApp.h"


// CStereoViewApp

BEGIN_MESSAGE_MAP(CStereoViewApp, CWinApp)
END_MESSAGE_MAP()

// The one and only CStereoViewApp object
CStereoViewApp theApp;

// CStereoViewApp initialization

BOOL CStereoViewApp::InitInstance()
{
  // CRITICAL: DO NOT CALL RHINO SDK FUNCTIONS HERE!
  // Only standard MFC DLL instance initialization belongs here. 
  // All other significant initialization should take place in
  // CStereoViewPlugIn::OnLoadPlugIn().

	CWinApp::InitInstance();

	return TRUE;
}

int CStereoViewApp::ExitInstance()
{
  // CRITICAL: DO NOT CALL RHINO SDK FUNCTIONS HERE!
  // Only standard MFC DLL instance clean up belongs here. 
  // All other significant cleanup should take place in either
  // CStereoViewPlugIn::OnSaveAllSettings() or
  // CStereoViewPlugIn::OnUnloadPlugIn().
  return CWinApp::ExitInstance();
}

CStereoViewApp& StereoApp(void)
{
  return theApp;
}

CStereoSettings CStereoViewApp::StereoSettings(void)
{
  return m_Conduit.GetSettings();
}

void CStereoViewApp::SetStereoSettings(const CStereoSettings & settings)
{
  m_Conduit.SetSettings(settings);
  CRhinoDoc*  pDoc = ::RhinoApp().ActiveDoc();
  if (pDoc != nullptr)
    pDoc->Regen();
}

void CStereoViewApp::EnableStereo(const ON_UUID & ViewId, int state)
{
  CRhinoDoc*  pDoc = ::RhinoApp().ActiveDoc();

  if (pDoc == nullptr)
    return;

  CRhinoView*  pTargetView = nullptr;

  CRhinoModelViewIterator view_it(pDoc->RuntimeSerialNumber());
  for (CRhinoView* pView = view_it.First(); 0 != pView; pView = view_it.Next())
  {
    if (ViewId == pView->MainViewport().ViewportId())
    {
      pTargetView = pView;
      break;
    }
  }

  CRhinoDisplayPipeline* dp = pTargetView ? pTargetView->DisplayPipeline() : nullptr;

  if (dp)
  {
    HWND _hWnd = pTargetView->GetSafeHwnd();

    if (_hWnd == nullptr)
      return;

    HDC _hDC = ::GetDC(_hWnd);
    int _pf  = ::GetPixelFormat(_hDC);

    ::ReleaseDC(_hWnd, _hDC);

    PIXELFORMATDESCRIPTOR  _pfd = {0};

    ::DescribePixelFormat(_hDC, _pf, sizeof(_pfd), &_pfd);
    if ((_pfd.dwFlags & PFD_STEREO) == 0)
      return;

    bool  bEnableStereo = (state == 1);

    if (bEnableStereo)
    {
      if (!m_Conduit.IsBound(*dp))
      {
        m_Conduit.Bind(*dp);
      }
    }
    else if (m_Conduit.IsBound(*dp))
    {
      m_Conduit.Unbind(*dp);
    }
    if (m_Conduit.BindingCount() == 0)
      m_Conduit.Disable();
    else if (!m_Conduit.IsEnabled())
      m_Conduit.Enable();

    pDoc->Regen();
  }
}

bool CStereoViewApp::IsStereoEnabled(const ON_UUID& ViewId)
{
  CRhinoDoc*  pDoc = ::RhinoApp().ActiveDoc();

  if (pDoc == nullptr)
    return false;

  CRhinoView*  pTargetView = nullptr;

  CRhinoModelViewIterator view_it(pDoc->RuntimeSerialNumber());
  for (CRhinoView* pView = view_it.First(); 0 != pView; pView = view_it.Next())
  {
    if (ViewId == pView->MainViewport().ViewportId())
    {
      pTargetView = pView;
      break;
    }
  }

  CRhinoDisplayPipeline* dp = pTargetView ? pTargetView->DisplayPipeline() : nullptr;

  if (dp)
  {
    return m_Conduit.IsBound(*dp);
  }
  return false;
}

