#pragma once
class CRhStereoOptions : public CRhinoTabbedDockBarDialog,
                         public CRhinoEventWatcher
{
  DECLARE_DYNCREATE(CRhStereoOptions)

public:
  CRhStereoOptions(void);
  virtual ~CRhStereoOptions(void);

  virtual const wchar_t* Caption(void) const;
  virtual ON_UUID TabId(void) const;
  virtual ON_UUID PlugInId(void) const;

  static
    ON_UUID  ID(void);

  virtual void OnCreateView(CRhinoView* rhino_view) override;
  virtual void OnDestroyView(CRhinoView* rhino_view) override;
  virtual void OnSetActiveView(CRhinoView* rhino_view) override;
  virtual void OnRenameView(CRhinoView* rhino_view) override;

protected:
  CRhinoUiCheckListBox m_views;
  ON_SimpleArray<ON_UUID> m_viewIds;

  CSliderCtrl  m_Parallax;
  CSliderCtrl  m_Separation;

  virtual void DoDataExchange(CDataExchange* pDX);
  afx_msg void OnSize(UINT nType, int cx, int cy);
  afx_msg void OnListViewSelChange();
  afx_msg void OnListViewCheckChange();
  DECLARE_MESSAGE_MAP()

private:
  void BuildViewList(CRhinoView* pSkipView = nullptr);
  void AddCheckBoxHelper(const wchar_t* str, const ON_UUID& viewport_id);


public:
  virtual BOOL OnInitDialog();
  afx_msg void OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar);
};

